package com.censoft.censoftrongtong.controller;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.hutool.core.convert.Convert;
import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.domain.dto.RiskInherentListExportDto;
import com.censoft.censoftrongtong.domain.dto.RiskNotificationExportWordDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppTaskDetailsDto;
import com.censoft.censoftrongtong.enums.RiskPlanStatusType;
import com.censoft.censoftrongtong.service.IRiskPlanInherentListService;
import com.censoft.censoftrongtong.service.IRiskPlanService;
import com.ruoyi.common.utils.WordUtil;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

import static com.ruoyi.common.utils.SecurityUtils.getLoginUser;

/**
 * 风险计划Controller
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@RestController
@RequestMapping("/system/risk/plan")
public class RiskPlanController extends BaseController
{
    @Autowired
    private IRiskPlanService riskPlanService;

    @Resource
    private IRiskPlanInherentListService riskPlanInherentListService;

    /**
     * 查询风险计划列表
     */
    @GetMapping("/list")
    public TableDataInfo list(RiskPlan riskPlan)
    {
        startPage();
        if ("ledger".equals(riskPlan.getIsLedger())){
            riskPlan.setCreateDeptId(getDeptId());
        }else {
            riskPlan.setCreateUserId(getLoginUser().getUserId());
        }
        List<RiskPlanAppTaskDetailsDto> list = riskPlanService.selectRiskPlanList(riskPlan);
        list.forEach(dto -> {
            dto.setStatusName(RiskPlanStatusType.getTitleByStatus(dto.getStatus()).getTitle());
        });


        return getDataTable(list);
    }

    /**
     * 导出风险计划列表
     */
    //@PreAuthorize("@ss.hasPermi('system:riskPlan:export')")
    //@Log(title = "风险计划", businessType = BusinessType.EXPORT)
    //@PostMapping("/export")
    //public void export(HttpServletResponse response, RiskPlan riskPlan)
    //{
    //    List<RiskPlan> list = riskPlanService.selectRiskPlanList(riskPlan);
    //    ExcelUtil<RiskPlan> util = new ExcelUtil<RiskPlan>(RiskPlan.class);
    //    util.exportExcel(response, list, "风险计划数据");
    //}

    /**
     * 获取风险计划详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:riskPlan:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(riskPlanService.selectRiskPlanById(id));
    }

    /**
     * 新增风险计划
     */
    @PreAuthorize("@ss.hasPermi('system:riskPlan:add')")
    @Log(title = "风险计划", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RiskPlan riskPlan)
    {
        return toAjax(riskPlanService.insertRiskPlan(riskPlan));
    }

    /**
     * 修改风险计划
     */
    @PreAuthorize("@ss.hasPermi('system:riskPlan:edit')")
    @Log(title = "风险计划", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RiskPlan riskPlan)
    {
        return toAjax(riskPlanService.updateRiskPlan(riskPlan));
    }

    /**
     * 删除风险计划
     */
    @PreAuthorize("@ss.hasPermi('system:riskPlan:remove')")
    @Log(title = "风险计划", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(riskPlanService.deleteRiskPlanByIds(ids));
    }





    @PostMapping("/exportWord/riskNotification/{inherentId}")
    public void exportWord(@PathVariable Long inherentId,
            HttpServletRequest request, HttpServletResponse response) throws IOException {

        RiskNotificationExportWordDto exportWordDto = riskPlanInherentListService.getRiskNotificationExportWordDto(inherentId);
        Map<String, Object> dataMap = Convert.convert(Map.class, exportWordDto);

        dataMap.put("title", "风险告知卡");
        dataMap.put("path", "D:/ruoyi/uploadPath/upload/");
        // 数据填装至模板，保存文件
        String name = WordUtil.createDoc(dataMap, "word.ftl");
        // word导出
        WordUtil.responseDownloadFile(request, response, "D:/ruoyi/uploadPath/upload/", name);
    }


    /**
     * 导出项目风险清单表
     */
    @PostMapping("/exportExcel/InherentList/{planId}")
    public void export(@PathVariable Long planId, HttpServletResponse response) {
        try {
            List<RiskInherentListExportDto> dtos = riskPlanInherentListService.getPlanInherentListByPlanId(planId);
            riskPlanInherentListService.exportPlanInherentList(response,dtos);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
