package com.censoft.censoftrongtong.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.domain.RiskPlanTask;
import com.censoft.censoftrongtong.domain.RiskPlanUserBuilding;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppApproveBuildingDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppBuildingListDto;
import com.censoft.censoftrongtong.enums.RiskPlanStatusType;
import com.censoft.censoftrongtong.mapper.RiskPlanUserBuildingMapper;
import com.censoft.censoftrongtong.service.IRiskPlanService;
import com.censoft.censoftrongtong.service.IRiskPlanTaskService;
import com.censoft.censoftrongtong.service.IRiskPlanUserBuildingService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 基础数据-楼层Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanUserBuildingServiceImpl
        extends ServiceImpl<RiskPlanUserBuildingMapper, RiskPlanUserBuilding>
        implements IRiskPlanUserBuildingService {

    @Resource
    private RiskPlanUserBuildingMapper riskPlanUserBuildingMapper;

    @Resource
    private IRiskPlanService riskPlanService;

    @Resource
    private IRiskPlanTaskService riskPlanTaskService;


    @Override
    public Long countStatusByPlanIdAndStatus(Long planId, String status) {
        LambdaQueryWrapper<RiskPlanUserBuilding> wrapper = new LambdaQueryWrapper<>();
        wrapper = wrapper.eq(RiskPlanUserBuilding::getPlanId, planId);
        if (status != null){
            wrapper = wrapper.eq(RiskPlanUserBuilding::getStatus, status);
        }
        return count(wrapper);
    }

    @Override
    public List<RiskPlanAppBuildingListDto> getRiskPlanAppBuildingListDtoByPlanId(Long planId) {
        return riskPlanUserBuildingMapper.getRiskPlanAppBuildingListDtoByPlanId(planId);
    }

    @Override
    public Integer submitByPlanIdAndBuildingId(Long planId, Long buildingId, Long userId) {
        //更新楼宇人员关系表状态
        LambdaQueryWrapper<RiskPlanUserBuilding> wrapper = new LambdaQueryWrapper<>();
        wrapper = wrapper.eq(RiskPlanUserBuilding::getPlanId, planId).eq(RiskPlanUserBuilding::getBuildingId, buildingId);
        RiskPlanUserBuilding riskPlanUserBuilding = getOne(wrapper);

        riskPlanUserBuilding.setStatus("finish");
        riskPlanUserBuilding.setFinishTime(new Date());
        riskPlanUserBuilding.setSubmitUserId(userId);
        updateById(riskPlanUserBuilding);

        //如果完成一项
        RiskPlan riskPlan = riskPlanService.selectRiskPlanById(planId);
        RiskPlanTask lastRiskPlanTask = riskPlanTaskService.getLastRiskPlanTaskByPlanId(planId);
        if (RiskPlanStatusType.WAIT_START.getStatus().equals(riskPlan.getStatus())) {
            //修改任务状态
            lastRiskPlanTask.setStatus("completed");
            lastRiskPlanTask.setCompletedTime(new Date());
            riskPlanTaskService.updateRiskPlanTask(lastRiskPlanTask);

            //创建任务执行状态
            RiskPlanTask riskPlanTask1 = new RiskPlanTask();
            riskPlanTask1.setPlanId(planId);
            riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
            riskPlanTask1.setTaskKey(RiskPlanStatusType.RUNNING.getStatus());
            riskPlanTask1.setTaskName(RiskPlanStatusType.RUNNING.getTitle());
            riskPlanTask1.setStatus("running");
            riskPlanTask1.setStartTime(new Date());
            riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);

            //修改计划状态
            riskPlan.setStatus(RiskPlanStatusType.RUNNING.getStatus());
            riskPlanService.updateRiskPlan(riskPlan);
        }

        //查看是否全部楼宇提交
        LambdaQueryWrapper<RiskPlanUserBuilding> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2 = wrapper2.eq(RiskPlanUserBuilding::getPlanId, planId);
        List<RiskPlanUserBuilding> list = list(wrapper2);
        if (list.stream().allMatch(po -> po.getStatus().equals("finish"))) {

            //获取最新的task
            lastRiskPlanTask = riskPlanTaskService.getLastRiskPlanTaskByPlanId(planId);
            lastRiskPlanTask.setStatus("completed");
            lastRiskPlanTask.setCompletedTime(new Date());
            riskPlanTaskService.updateRiskPlanTask(lastRiskPlanTask);

            //计划
            riskPlan = riskPlanService.selectRiskPlanById(planId);

            //插入任务表 组长验收任务
            RiskPlanTask riskPlanTask1 = new RiskPlanTask();
            riskPlanTask1.setPlanId(lastRiskPlanTask.getPlanId());
            riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
            riskPlanTask1.setTaskKey(RiskPlanStatusType.WAIT_LEADER_APPROVE.getStatus());
            riskPlanTask1.setTaskName(RiskPlanStatusType.WAIT_LEADER_APPROVE.getTitle());
            riskPlanTask1.setStatus("running");
            riskPlanTask1.setStartTime(new Date());
            riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);

            //修改计划状态
            riskPlan.setStatus(RiskPlanStatusType.WAIT_LEADER_APPROVE.getStatus());
            riskPlanService.updateRiskPlan(riskPlan);

        }
        return 1;
    }

    @Override
    public void updateByRiskPlanAppApproveBuildingDto(Long planId, Long userId, List<RiskPlanAppApproveBuildingDto> buildingDtos) {
        buildingDtos.forEach(dto -> {
            LambdaQueryWrapper<RiskPlanUserBuilding> wrapper = new LambdaQueryWrapper<>();
            wrapper = wrapper
                    .eq(RiskPlanUserBuilding::getPlanId, planId)
                    .eq(RiskPlanUserBuilding::getBuildingId, dto.getBuildingId());
            RiskPlanUserBuilding planUserBuilding = getOne(wrapper);
            planUserBuilding.setTaskResult(dto.getTaskResult());
            planUserBuilding.setTaskOpinion(dto.getTaskOpinion());
            planUserBuilding.setStatus("return");
            planUserBuilding.setApprovalUserId(userId);
            updateById(planUserBuilding);
        });
    }

    @Override
    public void deleteByPlanId(Long planId) {
        LambdaQueryWrapper<RiskPlanUserBuilding> wrapper = new LambdaQueryWrapper<>();
        wrapper = wrapper.eq(RiskPlanUserBuilding::getPlanId, planId);
        remove(wrapper);
    }
}
