package com.censoft.censoftrongtong.controller;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * 首页相关接口Controller
 *
 * @author ruoyi
 * @date 2023-03-20
 */
@Api(tags = {"首页统计相关接口"})
@RestController
@RequestMapping("/system/index")
@AllArgsConstructor
public class IndexController extends BaseController {


    /**
     * 项目,楼栋,楼层和房间数据统计
     */

    @ApiOperation("项目,楼栋,楼层和房间数据统计")
    @GetMapping("/getBaseInfoNum")
    public R getQygk() {

        int projectCount = 0;//项目数量
        int buildingCount = 0;//楼栋数量
        int floorCount = 0;//楼层数量
        int roomCount = 0;//房间数

        Map<String, String> map_gk = new HashMap<>();
        map_gk.put("projectNum", projectCount + "");
        map_gk.put("buildingNum", buildingCount + "");
        map_gk.put("floorNum", floorCount + "");
        map_gk.put("roomNum", roomCount + "");
        return R.ok(map_gk);
    }




}
