package com.censoft.censoftrongtong.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.censoft.censoftrongtong.domain.RiskPlanUserBuilding;
import com.censoft.censoftrongtong.mapper.RiskPlanUserBuildingMapper;
import com.censoft.censoftrongtong.service.IRiskPlanUserBuildingService;
import org.springframework.stereotype.Service;

/**
 * 基础数据-楼层Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanUserBuildingServiceImpl
        extends ServiceImpl<RiskPlanUserBuildingMapper, RiskPlanUserBuilding>
        implements IRiskPlanUserBuildingService {


    @Override
    public Long countStatusByPlanIdAndStatus(Long planId, String status) {
        LambdaQueryWrapper<RiskPlanUserBuilding> wrapper = new LambdaQueryWrapper<>();
        wrapper = wrapper.eq(RiskPlanUserBuilding::getPlanId, planId).eq(RiskPlanUserBuilding::getStatus, status);
        return count(wrapper);
    }
}
