package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.LedgerRoom;
import com.censoft.censoftrongtong.service.ILedgerRoomService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 基础数据-楼层Controller
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@RestController
@RequestMapping("/system/ledger/room")
public class LedgerRoomController extends BaseController
{
    @Autowired
    private ILedgerRoomService ledgerRoomService;

    /**
     * 查询基础数据-楼层列表
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerRoom:list')")
    @GetMapping("/list")
    public TableDataInfo list(LedgerRoom ledgerRoom)
    {
        startPage();
        List<LedgerRoom> list = ledgerRoomService.selectLedgerRoomList(ledgerRoom);
        return getDataTable(list);
    }

    /**
     * 导出基础数据-楼层列表
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerRoom:export')")
    @Log(title = "基础数据-楼层", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LedgerRoom ledgerRoom)
    {
        List<LedgerRoom> list = ledgerRoomService.selectLedgerRoomList(ledgerRoom);
        ExcelUtil<LedgerRoom> util = new ExcelUtil<LedgerRoom>(LedgerRoom.class);
        util.exportExcel(response, list, "基础数据-楼层数据");
    }

    /**
     * 获取基础数据-楼层详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerRoom:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ledgerRoomService.selectLedgerRoomById(id));
    }

    /**
     * 新增基础数据-楼层
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerRoom:add')")
    @Log(title = "基础数据-楼层", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody LedgerRoom ledgerRoom)
    {
        return toAjax(ledgerRoomService.insertLedgerRoom(ledgerRoom));
    }

    /**
     * 修改基础数据-楼层
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerRoom:edit')")
    @Log(title = "基础数据-楼层", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LedgerRoom ledgerRoom)
    {
        return toAjax(ledgerRoomService.updateLedgerRoom(ledgerRoom));
    }

    /**
     * 删除基础数据-楼层
     */
    @PreAuthorize("@ss.hasPermi('system:ledgerRoom:remove')")
    @Log(title = "基础数据-楼层", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ledgerRoomService.deleteLedgerRoomByIds(ids));
    }
}
