package com.censoft.censoftrongtong.controller;

import com.censoft.censoftrongtong.domain.EvaluationModelInfo;
import com.censoft.censoftrongtong.service.IEvaluationModelInfoService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 评估模型信息Controller
 * 
 * @author xjchen
 * @date 2023-08-08
 */
@RestController
@RequestMapping("/system/evaluation/factor")
public class EvaluationModelInfoController extends BaseController
{
    @Autowired
    private IEvaluationModelInfoService evaluationModelInfoService;

    /**
     * 查询评估模型信息列表
     */
    @PreAuthorize("@ss.hasPermi('system/evaluation:factor:list')")
    @GetMapping("/list")
    public TableDataInfo list(EvaluationModelInfo evaluationModelInfo)
    {
        startPage();
        List<EvaluationModelInfo> list = evaluationModelInfoService.selectEvaluationModelInfoList(evaluationModelInfo);
        return getDataTable(list);
    }

    /**
     * 导出评估模型信息列表
     */
    @PreAuthorize("@ss.hasPermi('system/evaluation:factor:export')")
    @Log(title = "评估模型信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, EvaluationModelInfo evaluationModelInfo)
    {
        List<EvaluationModelInfo> list = evaluationModelInfoService.selectEvaluationModelInfoList(evaluationModelInfo);
        ExcelUtil<EvaluationModelInfo> util = new ExcelUtil<EvaluationModelInfo>(EvaluationModelInfo.class);
        util.exportExcel(response, list, "评估模型信息数据");
    }

    /**
     * 获取评估模型信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('system/evaluation:factor:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(evaluationModelInfoService.selectEvaluationModelInfoById(id));
    }

    /**
     * 新增评估模型信息
     */
    @PreAuthorize("@ss.hasPermi('system/evaluation:factor:add')")
    @Log(title = "评估模型信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody EvaluationModelInfo evaluationModelInfo)
    {
        return toAjax(evaluationModelInfoService.insertEvaluationModelInfo(evaluationModelInfo));
    }

    /**
     * 修改评估模型信息
     */
    @PreAuthorize("@ss.hasPermi('system/evaluation:factor:edit')")
    @Log(title = "评估模型信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody EvaluationModelInfo evaluationModelInfo)
    {
        return toAjax(evaluationModelInfoService.updateEvaluationModelInfo(evaluationModelInfo));
    }

    /**
     * 删除评估模型信息
     */
    @PreAuthorize("@ss.hasPermi('system/evaluation:factor:remove')")
    @Log(title = "评估模型信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(evaluationModelInfoService.deleteEvaluationModelInfoByIds(ids));
    }


}
