package com.censoft.censoftrongtong.service.impl;

import cn.hutool.core.util.StrUtil;
import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.domain.dto.RiskExistingListSaveDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDetailsDto;
import com.censoft.censoftrongtong.domain.dto.statistics.*;
import com.censoft.censoftrongtong.mapper.RiskPlanExistingListMapper;
import com.censoft.censoftrongtong.service.IRiskPlanExistingListService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.service.ISysUploadFileService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 现有风险清单库Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanExistingListServiceImpl
        extends MPJBaseServiceImpl<RiskPlanExistingListMapper, RiskPlanExistingList>
        implements IRiskPlanExistingListService {
    @Autowired
    private RiskPlanExistingListMapper riskPlanExistingListMapper;

    @Resource
    private ISysUploadFileService uploadFileService;


    @Override
    public Long getNationalRiskNum(String areaName, Date beginTime,Long peojectId) {

        return riskPlanExistingListMapper.getNationalRiskNum(areaName, beginTime,peojectId);
    }

    @Override
    public List<RiskIndexRankingDto> getRiskIndexRanking(String areaName) {

        return riskPlanExistingListMapper.getRiskIndexRanking(areaName);
    }

    @Override
    public LinkedHashMap<String, Long> getAnnualRiskStatistics(String areaName) {

        return riskPlanExistingListMapper.getAnnualRiskStatistics(areaName);
    }

    @Override
    public List<RiskLevelStatisticsDto> getRiskLevelStatistics(String areaName,Long projectId) {
        return riskPlanExistingListMapper.getRiskLevelStatistics(areaName,projectId);
    }

    @Override
    public List<AccidentTypeStatisticsDto> getAccidentTypeStatistics(String areaName) {
        return riskPlanExistingListMapper.getAccidentTypeStatistics(areaName);
    }
    @Override
    public List<RiskProjectRankingDto> getRiskProjectRanking(String areaName, String level) {
        return riskPlanExistingListMapper.getRiskProjectRanking(areaName,level);
    }

    @Override
    public List<ProjectRiskInfoDto> getProjectRiskInfo(Long projectId, Long buildingId, Long floorId, String level) {
        return riskPlanExistingListMapper.getProjectRiskInfo(projectId,buildingId,floorId,level);
    }

    @Override
    public List<RiskMapStatisticsDto> getRiskMapStatistics(MapStatisticsQueryDto queryDto) {
        return riskPlanExistingListMapper.getRiskMapStatistics(queryDto);
    }




    /**
     * 查询现有风险清单库
     *
     * @param id 现有风险清单库主键
     * @return 现有风险清单库
     */
    @Override
    public RiskPlanExistingList selectRiskPlanExistingListById(Long id) {
        return riskPlanExistingListMapper.selectRiskPlanExistingListById(id);
    }

    /**
     * 查询现有风险清单库列表
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 现有风险清单库
     */
    @Override
    public List<RiskPlanExistingList> selectRiskPlanExistingListList(RiskPlanExistingList riskPlanExistingList) {
        return riskPlanExistingListMapper.selectRiskPlanExistingListList(riskPlanExistingList);
    }


    /**
     * 新增现有风险清单库
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    @Override
    public int insertRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList) {
        riskPlanExistingList.setCreateTime(DateUtils.getNowDate());
        return riskPlanExistingListMapper.insertRiskPlanExistingList(riskPlanExistingList);
    }

    /**
     * 修改现有风险清单库
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    @Override
    public int updateRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList) {
        riskPlanExistingList.setUpdateTime(DateUtils.getNowDate());
        return riskPlanExistingListMapper.updateRiskPlanExistingList(riskPlanExistingList);
    }

    /**
     * 批量删除现有风险清单库
     *
     * @param ids 需要删除的现有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanExistingListByIds(Long[] ids) {
        return riskPlanExistingListMapper.deleteRiskPlanExistingListByIds(ids);
    }

    /**
     * 删除现有风险清单库信息
     *
     * @param id 现有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanExistingListById(Long id) {
        return riskPlanExistingListMapper.deleteRiskPlanExistingListById(id);
    }

    @Override
    public RiskPlanAppExistingListDetailsDto getRiskPlanAppExistingListDetailsDtoByExistingId(Long existingId) {
        RiskPlanAppExistingListDetailsDto dto = riskPlanExistingListMapper.getRiskPlanAppExistingListDetailsDtoByExistingId(existingId);

        //风险源照片
        if (!StrUtil.hasEmpty(dto.getPictureFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getPictureFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setPictureFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //工程技术措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresProjectFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresProjectFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresProjectFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //管理措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresAdministrationFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresAdministrationFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresAdministrationFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //应急处置措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresEmergencyFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresEmergencyFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresEmergencyFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        return dto;
    }

    @Override
    public Boolean saveRiskExistingListSaveDto(RiskExistingListSaveDto saveDto) {
        RiskPlanExistingList existingList = new RiskPlanExistingList();
        BeanUtils.copyProperties(saveDto, existingList);
        existingList.setCreateTime(new Date());
        return saveOrUpdate(existingList);
    }
}
