package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 固有风险清单库对象 risk_inherent_list
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
@TableName("risk_inherent_list")
public class RiskInherentList extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 风险源名称
     */
    @TableField("name")
    private String name;

    /**
     * 风险点类型
     */
    @TableField("point_type")
    private String pointType;

    /**
     * 是否为特种设备
     */
    @TableField("special_equipment")
    private Boolean specialEquipment;

    /**
     * 安全警示标志
     */
    @TableField("safety_warning_signs")
    private String safetyWarningSigns;

    /**
     * 风险因素
     */
    @TableField("factor")
    private String factor;

    /**
     * 准事故类型
     */
    @TableField("type")
    private String type;

    /**
     * 工程技术措施
     */
    @TableField("measures_project")
    private String measuresProject;

    /**
     * 应采取的管理措施
     */
    @TableField("measures_administration")
    private String measuresAdministration;

    /**
     * 应急措施
     */
    @TableField("measures_emergency")
    private String measuresEmergency;

    /**
     * 是否存在重大危险源
     */
    @TableField("major_hazard_source")
    private Boolean majorHazardSource;

    /**
     * 危险源名称
     */
    @TableField("hazard_source_name")
    private String hazardSourceName;

    /**
     * 重大危险源描述
     */
    @TableField("major_hazard_source_description")
    private String majorHazardSourceDescription;

    /**
     * 参考依据
     */
    @TableField("reference_basis")
    private String referenceBasis;

    /**
     * 删除标志（0代表存在 1代表删除）
     */
    @TableField("del_flag")
    private String delFlag;
}
