package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

/**
 * 固有风险清单库对象 risk_plan_inherent_list
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
@TableName("risk_plan_inherent_list")
public class RiskPlanInherentList extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 评估人id
     */
    @TableField("user_id")
    private Long userId;

    /**
     * 房间id
     */
    @TableField("room_id")
    private Long roomId;

    /**
     * 计划id
     */
    @TableField("plan_id")
    private Long planId;

    /**
     * 风险源名称
     */
    @TableField("name")
    private String name;

    /**
     * 风险点类型
     */
    @TableField("point_type")
    private String pointType;

    /**
     * 安全警示标志
     */
    @TableField("safety_warning_signs")
    private String safetyWarningSigns;

    /**
     * 风险因素
     */
    @TableField("factor")
    private String factor;

    /**
     * 准事故类型
     */
    @TableField("type")
    private String type;

    /**
     * 风险等级
     */
    @TableField("level")
    private String level;

    /**
     * 风险可能性
     */
    @TableField("risk_likelihood")
    private String riskLikelihood;

    /**
     * 后果严重性
     */
    @TableField("risk_severity")
    private String riskSeverity;

    /**
     * 存在部位
     */
    @TableField("presence_location")
    private String presenceLocation;

    /**
     * 风险源照片id
     */
    @TableField("picture_file_ids")
    private String pictureFileIds;

    /**
     * 工程技术措施
     */
    @TableField("measures_project")
    private String measuresProject;

    /**
     * 工程技术措施附件
     */
    @TableField("measures_project_file_ids")
    private String measuresProjectFileIds;

    /**
     * 应采取的管理措施
     */
    @TableField("measures_administration")
    private String measuresAdministration;

    /**
     * 管控责任单位id
     */
    @TableField("measures_dept_id")
    private Long measuresDeptId;

    /**
     * 管控责任人id
     */
    @TableField("measures_user_id")
    private Long measuresUserId;

    /**
     * 已采取的管理措施
     */
    @TableField("measures_administration_file_ids")
    private String measuresAdministrationFileIds;

    /**
     * 危险源名称
     */
    @TableField("hazard_source_name")
    private String hazardSourceName;

    /**
     * 是否存在重大危险源
     */
    @TableField("major_hazard_source")
    private Boolean majorHazardSource;

    /**
     * 重大危险源描述
     */
    @TableField("major_hazard_source_description")
    private String majorHazardSourceDescription;

    /**
     * 应急措施
     */
    @TableField("measures_emergency")
    private String measuresEmergency;

    /**
     * 应急处置措施附件
     */
    @TableField("measures_emergency_file_ids")
    private String measuresEmergencyFileIds;

    /**
     * 参考依据
     */
    @TableField("reference_basis")
    private String referenceBasis;

    /**
     * 删除标志（0代表存在 1代表删除）
     */
    @TableField("del_flag")
    private String delFlag;
}
