package com.censoft.censoftrongtong.controller;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.censoft.censoftrongtong.domain.LedgerRoom;
import com.censoft.censoftrongtong.service.ILedgerRoomService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 基础数据-楼层Controller
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@RestController
@RequestMapping(value={"/app-api/ledger/room","/system/ledger/room"})
public class LedgerRoomController extends BaseController
{
    @Autowired
    private ILedgerRoomService ledgerRoomService;

    /**
     * 查询基础数据-楼层列表
     */
    @GetMapping("/list")
    public AjaxResult list(LedgerRoom ledgerRoom)
    {
        ledgerRoom.setDelFlag("0");
        List<LedgerRoom> list =ledgerRoomService.selectLedgerRoomList(ledgerRoom);
        return success(list);
    }

    /**
     * 导出基础数据-楼层列表
     */
    @Log(title = "基础数据-楼层", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LedgerRoom ledgerRoom)
    {
        QueryWrapper<LedgerRoom> queryWrapper = new QueryWrapper<>();
        List<LedgerRoom> list = ledgerRoomService.list(queryWrapper);
        ExcelUtil<LedgerRoom> util = new ExcelUtil<LedgerRoom>(LedgerRoom.class);
        util.exportExcel(response, list, "基础数据-楼层数据");
    }

    /**
     * 获取基础数据-楼层详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ledgerRoomService.getById(id));
    }

    /**
     * 新增基础数据-楼层
     */
    @Log(title = "基础数据-楼层", businessType = BusinessType.INSERT)
    @PostMapping(value = "/save")
    public AjaxResult add(@RequestBody LedgerRoom ledgerRoom)
    {
        return toAjax(ledgerRoomService.save(ledgerRoom));
    }

    /**
     * 修改基础数据-楼层
     */
    @Log(title = "基础数据-楼层", businessType = BusinessType.UPDATE)
    @PostMapping("/update")
    public AjaxResult edit(@RequestBody LedgerRoom ledgerRoom)
    {
        return toAjax(ledgerRoomService.updateById(ledgerRoom));
    }

    /**
     * 批量修改基础数据-楼层
     */
    @Log(title = "基础数据-楼层", businessType = BusinessType.UPDATE)
    @PostMapping("/update/batch")
    public AjaxResult edit(@RequestBody List<LedgerRoom> ledgerRooms)
    {
        return toAjax(ledgerRoomService.updateBatchById(ledgerRooms));
    }

    /**
     * 删除基础数据-楼层
     */
    @Log(title = "基础数据-楼层", businessType = BusinessType.DELETE)
	@PostMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        QueryWrapper<LedgerRoom> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id", Arrays.asList(ids));
        ledgerRoomService.remove(queryWrapper);
        return AjaxResult.success();
    }
}
