package com.ruoyi.system.service;

import java.util.List;
import com.ruoyi.system.domain.Websites;
import com.baomidou.mybatisplus.extension.service.IService;
/**
 * 网站管理Service接口
 * 
 * @author ruoyi
 * @date 2023-06-27
 */
public interface IWebsitesService  extends IService<Websites>
{
    /**
     * 查询网站管理
     * 
     * @param id 网站管理主键
     * @return 网站管理
     */
    public Websites selectWebsitesById(Long id);

    /**
     * 查询网站管理列表
     * 
     * @param websites 网站管理
     * @return 网站管理集合
     */
    public List<Websites> selectWebsitesList(Websites websites);

    /**
     * 新增网站管理
     * 
     * @param websites 网站管理
     * @return 结果
     */
    public int insertWebsites(Websites websites);

    /**
     * 修改网站管理
     * 
     * @param websites 网站管理
     * @return 结果
     */
    public int updateWebsites(Websites websites);

    /**
     * 批量删除网站管理
     * 
     * @param ids 需要删除的网站管理主键集合
     * @return 结果
     */
    public int deleteWebsitesByIds(Long[] ids);

    /**
     * 删除网站管理信息
     * 
     * @param id 网站管理主键
     * @return 结果
     */
    public int deleteWebsitesById(Long id);
}
