package com.ruoyi.system.domain;

import com.ruoyi.common.core.domain.BaseEntityClean;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 网站管理对象 websites
 * 
 * @author ruoyi
 * @date 2023-06-27
 */
public class Websites extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 站点名称 */
    @Excel(name = "站点名称")
    private String name;

    /** 网址 */
    @Excel(name = "网址")
    private String url;

    /** Alexa 排名 */
    @Excel(name = "Alexa 排名")
    private Long alexa;

    /** 国家 */
    @Excel(name = "国家")
    private String country;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setUrl(String url) 
    {
        this.url = url;
    }

    public String getUrl() 
    {
        return url;
    }
    public void setAlexa(Long alexa) 
    {
        this.alexa = alexa;
    }

    public Long getAlexa() 
    {
        return alexa;
    }
    public void setCountry(String country) 
    {
        this.country = country;
    }

    public String getCountry() 
    {
        return country;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("url", getUrl())
            .append("alexa", getAlexa())
            .append("country", getCountry())
            .toString();
    }
}
