package com.censoft.censoftrongtong.service.impl;

import com.censoft.censoftrongtong.domain.RiskInherentList;
import com.censoft.censoftrongtong.mapper.RiskInherentListMapper;
import com.censoft.censoftrongtong.service.IRiskInherentListService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 固有风险清单库Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskInherentListServiceImpl extends MPJBaseServiceImpl<RiskInherentListMapper, RiskInherentList>  implements IRiskInherentListService
{
    @Autowired
    private RiskInherentListMapper riskInherentListMapper;

    /**
     * 查询固有风险清单库
     * 
     * @param id 固有风险清单库主键
     * @return 固有风险清单库
     */
    @Override
    public RiskInherentList selectRiskInherentListById(Long id)
    {
        return riskInherentListMapper.selectRiskInherentListById(id);
    }

    /**
     * 查询固有风险清单库列表
     * 
     * @param riskInherentList 固有风险清单库
     * @return 固有风险清单库
     */
    @Override
    public List<RiskInherentList> selectRiskInherentListList(RiskInherentList riskInherentList)
    {
        return riskInherentListMapper.selectRiskInherentListList(riskInherentList);
    }

    /**
     * 新增固有风险清单库
     * 
     * @param riskInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int insertRiskInherentList(RiskInherentList riskInherentList)
    {
        riskInherentList.setCreateTime(DateUtils.getNowDate());
        return riskInherentListMapper.insertRiskInherentList(riskInherentList);
    }

    /**
     * 修改固有风险清单库
     * 
     * @param riskInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int updateRiskInherentList(RiskInherentList riskInherentList)
    {
        riskInherentList.setUpdateTime(DateUtils.getNowDate());
        return riskInherentListMapper.updateRiskInherentList(riskInherentList);
    }

    /**
     * 批量删除固有风险清单库
     * 
     * @param ids 需要删除的固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskInherentListByIds(Long[] ids)
    {
        return riskInherentListMapper.deleteRiskInherentListByIds(ids);
    }

    /**
     * 删除固有风险清单库信息
     * 
     * @param id 固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskInherentListById(Long id)
    {
        return riskInherentListMapper.deleteRiskInherentListById(id);
    }
}
