package com.censoft.censoftrongtong.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.censoft.censoftrongtong.domain.LedgerRoom;
import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.dto.LedgerRoomDto;
import com.censoft.censoftrongtong.mapper.LedgerRoomMapper;
import com.censoft.censoftrongtong.service.ILedgerRoomService;
import com.censoft.censoftrongtong.service.IRiskPlanExistingListService;
import com.censoft.censoftrongtong.service.IRiskPlanInherentListService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.core.domain.model.LoginUser;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 基础数据-楼层Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class LedgerRoomServiceImpl extends MPJBaseServiceImpl<LedgerRoomMapper, LedgerRoom> implements ILedgerRoomService {

    @Resource
    private LedgerRoomMapper ledgerRoomMapper;

    @Resource
    private IRiskPlanInherentListService riskPlanInherentListService;

    @Resource
    private IRiskPlanExistingListService riskPlanExistingListService;

    @Override
    public List<LedgerRoom> getRoomListByFloorId(Long floorId) {
        LambdaQueryWrapper<LedgerRoom> wrapper = new LambdaQueryWrapper<LedgerRoom>()
                .eq(LedgerRoom::getFloorId, floorId)
                .eq(LedgerRoom::getStatus, "0");
        return list(wrapper);
    }

    @Override
    public List<LedgerRoom> selectLedgerRoomList(LedgerRoom ledgerRoom) {
        List<LedgerRoom> list = ledgerRoomMapper.selectLedgerRoomList(ledgerRoom);
        list.forEach(room->{
            room.setColor(getLevelColorByRoomId(room.getId()));
        });
        return list;
    }

    @Override
    public void deleteRoomByRoomIds(List<Long> targetRoomIds) {
        if (!targetRoomIds.isEmpty()) {
            ledgerRoomMapper.deleteRoomByRoomIds(targetRoomIds);
        }
    }

    @Override
    public Long copyRoom(LedgerRoom ledgerRoom, LoginUser loginUser, Long planId) {
        //复制房间
        Long roomId = ledgerRoom.getId();
        LedgerRoom room = getById(roomId);

        ledgerRoom.setPosition(room.getPosition());
        ledgerRoom.setId(null);
        ledgerRoom.setCreateBy(loginUser.getUsername());
        ledgerRoom.setStatus("0");
        ledgerRoom.setCreateTime(new Date());
        save(ledgerRoom);

        LambdaQueryWrapper<RiskPlanInherentList> wrapper = new LambdaQueryWrapper<>();
        wrapper = wrapper.eq(RiskPlanInherentList::getRoomId,roomId);
        List<RiskPlanInherentList> riskPlanInherentLists = riskPlanInherentListService.list(wrapper);
        for (RiskPlanInherentList riskPlanInherentList : riskPlanInherentLists) {
            //复制固有
            Long inherentListId = riskPlanInherentList.getId();
            riskPlanInherentList.setId(null);
            riskPlanInherentList.setRoomId(ledgerRoom.getId());
            riskPlanInherentList.setUserId(loginUser.getUserId());
            riskPlanInherentList.setPlanId(planId);
            riskPlanInherentList.setCreateBy(loginUser.getUsername());
            riskPlanInherentListService.save(riskPlanInherentList);

            LambdaQueryWrapper<RiskPlanExistingList> wrapper2 = new LambdaQueryWrapper<>();
            wrapper2 = wrapper2.eq(RiskPlanExistingList::getInherentId,inherentListId);
            List<RiskPlanExistingList> riskPlanExistingLists = riskPlanExistingListService.list(wrapper2);
            for (RiskPlanExistingList riskPlanExistingList : riskPlanExistingLists) {
                //复制现有
                riskPlanExistingList.setId(null);
                riskPlanExistingList.setInherentId(riskPlanInherentList.getId());
                riskPlanExistingList.setUserId(loginUser.getUserId());
                riskPlanExistingList.setPlanId(planId);
                riskPlanExistingList.setCreateBy(loginUser.getUsername());
                riskPlanExistingListService.save(riskPlanExistingList);
            }
        }
        return ledgerRoom.getId();
    }

    @Override
    public List<LedgerRoomDto> selectLedgerRoomDtoList(LedgerRoomDto ledgerRoomDto) {
        return ledgerRoomMapper.selectLedgerRoomDtoList(ledgerRoomDto);
    }

    private String getLevelColorByRoomId(Long roomId) {
        String level = ledgerRoomMapper.getLevelColorByRoomId(roomId);
        if (StrUtil.isBlank(level)) {return "#F0F1F5";}
        switch (level){
            case "重大风险":
                return "#FF4433";
            case "较大风险":
                return "#FF9800";
            case "一般风险":
                return "#FFFF00";
            case "低风险":
                return "#0091EA";
            default:
                return "#F0F1F5";
        }
    }
}
