package com.censoft.censoftrongtong.service;

import java.util.List;
import com.censoft.censoftrongtong.domain.ProjectUserPost;
import com.github.yulichang.base.MPJBaseService;
/**
 * 项目用户岗位关系Service接口
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
public interface IProjectUserPostService  extends MPJBaseService<ProjectUserPost>
{
    /**
     * 查询项目用户岗位关系
     * 
     * @param id 项目用户岗位关系主键
     * @return 项目用户岗位关系
     */
    public ProjectUserPost selectProjectUserPostById(Long id);

    /**
     * 查询项目用户岗位关系列表
     * 
     * @param projectUserPost 项目用户岗位关系
     * @return 项目用户岗位关系集合
     */
    public List<ProjectUserPost> selectProjectUserPostList(ProjectUserPost projectUserPost);

    /**
     * 新增项目用户岗位关系
     * 
     * @param projectUserPost 项目用户岗位关系
     * @return 结果
     */
    public int insertProjectUserPost(ProjectUserPost projectUserPost);

    /**
     * 修改项目用户岗位关系
     * 
     * @param projectUserPost 项目用户岗位关系
     * @return 结果
     */
    public int updateProjectUserPost(ProjectUserPost projectUserPost);

    /**
     * 批量删除项目用户岗位关系
     * 
     * @param ids 需要删除的项目用户岗位关系主键集合
     * @return 结果
     */
    public int deleteProjectUserPostByIds(Long[] ids);

    /**
     * 删除项目用户岗位关系信息
     * 
     * @param id 项目用户岗位关系主键
     * @return 结果
     */
    public int deleteProjectUserPostById(Long id);
}
