package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.LedgerRoom;
import com.censoft.censoftrongtong.domain.dto.LedgerRoomDto;
import com.github.yulichang.base.MPJBaseService;
import com.ruoyi.common.core.domain.model.LoginUser;

import java.util.List;

/**
 * 基础数据-楼层Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface ILedgerRoomService extends MPJBaseService<LedgerRoom>
{
    /**
     * 根据楼层查询该楼层房间列表
     * @param floorId
     * @return
     */

    List<LedgerRoom> getRoomListByFloorId(Long floorId);


    /**
     * 查询房间列表
     * @param ledgerRoom
     * @return
     */
    List<LedgerRoom> selectLedgerRoomList(LedgerRoom ledgerRoom);

    void deleteRoomByRoomIds(List<Long> targetRoomIds);

    Long copyRoom(LedgerRoom ledgerRoom, LoginUser loginUser, Long planId);

    List<LedgerRoomDto> selectLedgerRoomDtoList(LedgerRoomDto ledgerRoomDto);
}
