package com.censoft.censoftrongtong.service;

import java.util.List;

import com.censoft.censoftrongtong.domain.InfoLedger;
import com.github.yulichang.base.MPJBaseService;
/**
 * 数据中台资产项目数据Service接口
 * 
 * @author ruoyi
 * @date 2023-10-07
 */
public interface IInfoLedgerService  extends MPJBaseService<InfoLedger>
{
    /**
     * 查询数据中台资产项目数据
     * 
     * @param id 数据中台资产项目数据主键
     * @return 数据中台资产项目数据
     */
    public InfoLedger selectInfoLedgerById(String id);

    /**
     * 查询数据中台资产项目数据列表
     * 
     * @param infoLedger 数据中台资产项目数据
     * @return 数据中台资产项目数据集合
     */
    public List<InfoLedger> selectInfoLedgerList(InfoLedger infoLedger);

    /**
     * 新增数据中台资产项目数据
     * 
     * @param infoLedger 数据中台资产项目数据
     * @return 结果
     */
    public int insertInfoLedger(InfoLedger infoLedger);

    /**
     * 修改数据中台资产项目数据
     * 
     * @param infoLedger 数据中台资产项目数据
     * @return 结果
     */
    public int updateInfoLedger(InfoLedger infoLedger);

    /**
     * 批量删除数据中台资产项目数据
     * 
     * @param ids 需要删除的数据中台资产项目数据主键集合
     * @return 结果
     */
    public int deleteInfoLedgerByIds(String[] ids);

    /**
     * 删除数据中台资产项目数据信息
     * 
     * @param id 数据中台资产项目数据主键
     * @return 结果
     */
    public int deleteInfoLedgerById(String id);

    String saveOrUpdateByHttp();
}
