package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.EvaluationFactorItems;
import com.github.yulichang.base.MPJBaseService;

import java.util.List;
/**
 * 评估选项管理Service接口
 * 
 * @author xjchen
 * @date 2023-08-08
 */
public interface IEvaluationFactorItemsService  extends MPJBaseService<EvaluationFactorItems>
{
    /**
     * 查询评估选项管理
     * 
     * @param id 评估选项管理主键
     * @return 评估选项管理
     */
    public EvaluationFactorItems selectEvaluationFactorItemsById(Long id);

    /**
     * 查询评估选项管理列表
     * 
     * @param evaluationFactorItems 评估选项管理
     * @return 评估选项管理集合
     */
    public List<EvaluationFactorItems> selectEvaluationFactorItemsList(EvaluationFactorItems evaluationFactorItems);

    /**
     * 新增评估选项管理
     * 
     * @param evaluationFactorItems 评估选项管理
     * @return 结果
     */
    public int insertEvaluationFactorItems(EvaluationFactorItems evaluationFactorItems);

    /**
     * 修改评估选项管理
     * 
     * @param evaluationFactorItems 评估选项管理
     * @return 结果
     */
    public int updateEvaluationFactorItems(EvaluationFactorItems evaluationFactorItems);

    /**
     * 批量删除评估选项管理
     * 
     * @param ids 需要删除的评估选项管理主键集合
     * @return 结果
     */
    public int deleteEvaluationFactorItemsByIds(Long[] ids);

    /**
     * 删除评估选项管理信息
     * 
     * @param id 评估选项管理主键
     * @return 结果
     */
    public int deleteEvaluationFactorItemsById(Long id);
}
