package com.censoft.censoftrongtong.service;

import java.util.List;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrolDetail;
import com.github.yulichang.base.MPJBaseService;
/**
 * 现状风险用户巡查明细Service接口
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
public interface ICurrentRiskUserPatrolDetailService  extends MPJBaseService<CurrentRiskUserPatrolDetail>
{
    /**
     * 查询现状风险用户巡查明细
     * 
     * @param id 现状风险用户巡查明细主键
     * @return 现状风险用户巡查明细
     */
    public CurrentRiskUserPatrolDetail selectCurrentRiskUserPatrolDetailById(Long id);

    /**
     * 查询现状风险用户巡查明细列表
     * 
     * @param currentRiskUserPatrolDetail 现状风险用户巡查明细
     * @return 现状风险用户巡查明细集合
     */
    public List<CurrentRiskUserPatrolDetail> selectCurrentRiskUserPatrolDetailList(CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail);

    /**
     * 新增现状风险用户巡查明细
     * 
     * @param currentRiskUserPatrolDetail 现状风险用户巡查明细
     * @return 结果
     */
    public int insertCurrentRiskUserPatrolDetail(CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail);

    /**
     * 修改现状风险用户巡查明细
     * 
     * @param currentRiskUserPatrolDetail 现状风险用户巡查明细
     * @return 结果
     */
    public int updateCurrentRiskUserPatrolDetail(CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail);

    /**
     * 批量删除现状风险用户巡查明细
     * 
     * @param ids 需要删除的现状风险用户巡查明细主键集合
     * @return 结果
     */
    public int deleteCurrentRiskUserPatrolDetailByIds(Long[] ids);

    /**
     * 删除现状风险用户巡查明细信息
     * 
     * @param id 现状风险用户巡查明细主键
     * @return 结果
     */
    public int deleteCurrentRiskUserPatrolDetailById(Long id);
}
