package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.LawList;
import com.censoft.censoftrongtong.domain.RiskSignRecord;
import com.censoft.censoftrongtong.domain.dto.RiskSignRecordShowDto;
import com.github.yulichang.base.MPJBaseMapper;

import java.util.List;

/**
 * 签到签退记录表Mapper接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface RiskSignRecordMapper extends  MPJBaseMapper<RiskSignRecord>
{
    /**
     * 查询签到签退记录
     *
     * @param id 签到签退记录主键
     * @return 签到签退记录
     */
    public RiskSignRecord selectRiskSignRecordById(Long id);

    /**
     * 查询签到签退记录列表
     *
     * @param riskSignRecord 签到签退记录
     * @return 签到签退记录集合
     */
    public List<RiskSignRecord> selectRiskSignRecordList(RiskSignRecord riskSignRecord);

    /**
     * 新增签到签退记录
     *
     * @param riskSignRecord 签到签退记录
     * @return 结果
     */
    public int insertRiskSignRecord(RiskSignRecord riskSignRecord);

    /**
     * 修改签到签退记录
     *
     * @param riskSignRecord 签到签退记录
     * @return 结果
     */
    public int updateRiskSignRecord(RiskSignRecord riskSignRecord);

    /**
     * 删除签到签退记录
     *
     * @param id 签到签退记录主键
     * @return 结果
     */
    public int deleteRiskSignRecordById(Long id);

    /**
     * 批量删除签到签退记录
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteRiskSignRecordByIds(Long[] ids);


    List<RiskSignRecordShowDto> selectRiskSignRecordShowDtoList(RiskSignRecordShowDto riskSignRecord);
}
