package com.censoft.censoftrongtong.mapper;

import java.util.List;

import com.censoft.censoftrongtong.domain.InfoAssets;
import com.github.yulichang.base.MPJBaseMapper;

/**
 * 数据中台资产数据Mapper接口
 * 
 * @author ruoyi
 * @date 2023-10-07
 */
public interface InfoAssetsMapper  extends MPJBaseMapper<InfoAssets>
{
    /**
     * 查询数据中台资产数据
     * 
     * @param id 数据中台资产数据主键
     * @return 数据中台资产数据
     */
    public InfoAssets selectInfoAssetsById(String id);

    /**
     * 查询数据中台资产数据列表
     * 
     * @param infoAssets 数据中台资产数据
     * @return 数据中台资产数据集合
     */
    public List<InfoAssets> selectInfoAssetsList(InfoAssets infoAssets);

    /**
     * 新增数据中台资产数据
     * 
     * @param infoAssets 数据中台资产数据
     * @return 结果
     */
    public int insertInfoAssets(InfoAssets infoAssets);

    /**
     * 修改数据中台资产数据
     * 
     * @param infoAssets 数据中台资产数据
     * @return 结果
     */
    public int updateInfoAssets(InfoAssets infoAssets);

    /**
     * 删除数据中台资产数据
     * 
     * @param id 数据中台资产数据主键
     * @return 结果
     */
    public int deleteInfoAssetsById(String id);

    /**
     * 批量删除数据中台资产数据
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteInfoAssetsByIds(String[] ids);
}
