package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.EvaluationFactorItems;
import com.github.yulichang.base.MPJBaseMapper;

import java.util.List;

/**
 * 评估选项管理Mapper接口
 * 
 * @author xjchen
 * @date 2023-08-08
 */
public interface EvaluationFactorItemsMapper  extends MPJBaseMapper<EvaluationFactorItems>
{
    /**
     * 查询评估选项管理
     * 
     * @param id 评估选项管理主键
     * @return 评估选项管理
     */
    public EvaluationFactorItems selectEvaluationFactorItemsById(Long id);

    /**
     * 查询评估选项管理列表
     * 
     * @param evaluationFactorItems 评估选项管理
     * @return 评估选项管理集合
     */
    public List<EvaluationFactorItems> selectEvaluationFactorItemsList(EvaluationFactorItems evaluationFactorItems);

    /**
     * 新增评估选项管理
     * 
     * @param evaluationFactorItems 评估选项管理
     * @return 结果
     */
    public int insertEvaluationFactorItems(EvaluationFactorItems evaluationFactorItems);

    /**
     * 修改评估选项管理
     * 
     * @param evaluationFactorItems 评估选项管理
     * @return 结果
     */
    public int updateEvaluationFactorItems(EvaluationFactorItems evaluationFactorItems);

    /**
     * 删除评估选项管理
     * 
     * @param id 评估选项管理主键
     * @return 结果
     */
    public int deleteEvaluationFactorItemsById(Long id);

    /**
     * 批量删除评估选项管理
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteEvaluationFactorItemsByIds(Long[] ids);
}
