package com.censoft.censoftrongtong.mapper;

import java.util.List;
import com.censoft.censoftrongtong.domain.CurrentRiskDetailAbnormal;
import com.github.yulichang.base.MPJBaseMapper;

/**
 * 现状风险巡查异常信息Mapper接口
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
public interface CurrentRiskDetailAbnormalMapper  extends MPJBaseMapper<CurrentRiskDetailAbnormal>
{
    /**
     * 查询现状风险巡查异常信息
     * 
     * @param id 现状风险巡查异常信息主键
     * @return 现状风险巡查异常信息
     */
    public CurrentRiskDetailAbnormal selectCurrentRiskDetailAbnormalById(Long id);

    /**
     * 查询现状风险巡查异常信息列表
     * 
     * @param currentRiskDetailAbnormal 现状风险巡查异常信息
     * @return 现状风险巡查异常信息集合
     */
    public List<CurrentRiskDetailAbnormal> selectCurrentRiskDetailAbnormalList(CurrentRiskDetailAbnormal currentRiskDetailAbnormal);

    /**
     * 新增现状风险巡查异常信息
     * 
     * @param currentRiskDetailAbnormal 现状风险巡查异常信息
     * @return 结果
     */
    public int insertCurrentRiskDetailAbnormal(CurrentRiskDetailAbnormal currentRiskDetailAbnormal);

    /**
     * 修改现状风险巡查异常信息
     * 
     * @param currentRiskDetailAbnormal 现状风险巡查异常信息
     * @return 结果
     */
    public int updateCurrentRiskDetailAbnormal(CurrentRiskDetailAbnormal currentRiskDetailAbnormal);

    /**
     * 删除现状风险巡查异常信息
     * 
     * @param id 现状风险巡查异常信息主键
     * @return 结果
     */
    public int deleteCurrentRiskDetailAbnormalById(Long id);

    /**
     * 批量删除现状风险巡查异常信息
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteCurrentRiskDetailAbnormalByIds(Long[] ids);
}
