package com.censoft.censoftrongtong.domain.dto;

import lombok.Data;

/**
 * 固有风险清单库对象 risk_inherent_list
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class RiskInherentListExportDto {

    /**
     * id
     */
    private Long id;

    /**
     * 项目信息-区域公司
     */
    private String deptName;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 所属城市
     */
    private String city;

    /**
     * 项目业态
     */
    private String businessFormat;

    /**
     * 项目类型
     */
    private String type;

    /**
     * 项目风险清单-固有风险风险清单
     */
    private String inherentName;

    /**
     * 固有风险风险等级
     */
    private String inherentLevel;

    /**
     * 现有风险风险清单
     */
    private String existingName;

    /**
     * 现有风险风险等级
     */
    private String existingLevel;

    /**
     * 风险点位置
     */
    private String presenceLocation;

    /**
     * 可能导致的事故后果
     */
    private String listType;

    /**
     * 项目整体风险等级-固有风险
     */
    private String inherentProjectLevel;

    /**
     * 现有风险
     */
    private String existingProjectLevel;

    /**
     * 风险管控-应采取的管控措施
     */
    private String inherentMeasuresAdministration;

    /**
     * 已采取的管控措施
     */
    private String existingMeasuresAdministration;

    /**
     * 管控责任单位
     */
    private String measuresDeptName;

    /**
     * 管控责任人
     */
    private String measuresUserName;

    /**
     * 人员联系方式
     */
    private String measuresUserPhone;

    /**
     * 重大危险源管理-重大危险源名称
     */
    private String hazardSourceName;

    /**
     * 是否存在重大危险源
     */
    private String majorHazardSource;

    /**
     * 重大危险源描述
     */
    private String majorHazardDescription;

    /**
     * 判定依据
     */
    private String referenceBasis;

    /**
     * 任务id
     */
    private Long planId;
}
