package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 数据中台资产数据对象 info_assets
 * 
 * @author ruoyi
 * @date 2023-10-07
 */
@TableName("info_assets")
public class InfoAssets{
    private static final long serialVersionUID = 1L;

    /** 资产ID */
    @TableField("id")
    private String id;

    /** 资产名称 */
    @TableField("name")
    @Excel(name = "资产名称")
    private String name;

    /** 集团资产编码 */
    @TableField("out_id")
    @Excel(name = "集团资产编码")
    private String out_id;

    /** 管理单位 */
    @TableField("manage_corp_name")
    @Excel(name = "管理单位")
    private String manage_corp_name;

    /** 所属项目 */
    @TableField("proj_name")
    @Excel(name = "所属项目")
    private String proj_name;

    /** 资产类型 */
    @TableField("category_name")
    @Excel(name = "资产类型")
    private String category_name;

    /** 资产用途 */
    @TableField("type_name")
    @Excel(name = "资产用途")
    private String type_name;

    /** 是否有消防验收意见书 */
    @TableField("exist_fire_certificate")
    @Excel(name = "是否有消防验收意见书")
    private String exist_fire_certificate;

    /** 是否存在危房 */
    @TableField("exist_dilapidated_building")
    @Excel(name = "是否存在危房")
    private String exist_dilapidated_building;

    /** 危房鉴定等级 */
    @TableField("dilapidated_building_level")
    @Excel(name = "危房鉴定等级")
    private String dilapidated_building_level;

    /** 危房数量 */
    @TableField("dilapidated_building_quantity")
    @Excel(name = "危房数量")
    private String dilapidated_building_quantity;

    /** 危房面积（㎡） */
    @TableField("dilapidated_building_area")
    @Excel(name = "危房面积", readConverterExp = "㎡=")
    private String dilapidated_building_area;

    /** 纬度 */
    @TableField("lat")
    @Excel(name = "纬度")
    private String lat;

    /** 经度 */
    @TableField("lng")
    @Excel(name = "经度")
    private String lng;

    /** 省 */
    @TableField("province_name")
    @Excel(name = "省")
    private String province_name;

    /** 市 */
    @TableField("city_name")
    @Excel(name = "市")
    private String city_name;

    /** 区 */
    @TableField("district_name")
    @Excel(name = "区")
    private String district_name;

    /** 街道 */
    @TableField("street_name")
    @Excel(name = "街道")
    private String street_name;

    /** 详细地址 */
    @TableField("detail")
    @Excel(name = "详细地址")
    private String detail;

    /** 资产面积（㎡） */
    @TableField("area")
    @Excel(name = "资产面积", readConverterExp = "㎡=")
    private String area;

    /** 清册面积（㎡） */
    @TableField("inventory_area")
    @Excel(name = "清册面积", readConverterExp = "㎡=")
    private String inventory_area;

    /** 资产编码 */
    @TableField("asset_code")
    @Excel(name = "资产编码")
    private String asset_code;

    /** 规划用途 */
    @TableField("planned_uses")
    @Excel(name = "规划用途")
    private String planned_uses;

    /** 实际用途 */
    @TableField("practical_uses")
    @Excel(name = "实际用途")
    private String practical_uses;

    /** 建筑结构 */
    @TableField("building_structure")
    @Excel(name = "建筑结构")
    private String building_structure;

    /** 地上层数 */
    @TableField("ground_plies")
    @Excel(name = "地上层数")
    private String ground_plies;

    /** 地下层数 */
    @TableField("underground_plies")
    @Excel(name = "地下层数")
    private String underground_plies;

    /** 首层层高 */
    @TableField("first_floor_height")
    @Excel(name = "首层层高")
    private String first_floor_height;

    /** 其他层高 */
    @TableField("other_floor_height")
    @Excel(name = "其他层高")
    private String other_floor_height;

    /** 接收时间 */
    @TableField("receiving_date")
    @Excel(name = "接收时间")
    private String receiving_date;

    /** 房产状态 */
    @TableField("property_status")
    @Excel(name = "房产状态")
    private String property_status;

    /** 建成年份 */
    @TableField("year_built")
    @Excel(name = "建成年份")
    private String year_built;

    /** 产权情况 */
    @TableField("property_detail")
    @Excel(name = "产权情况")
    private String property_detail;

    /** 产权单位 */
    @TableField("property_corp_name")
    @Excel(name = "产权单位")
    private String property_corp_name;

    /** 不动产证号（房产证） */
    @TableField("property_deeds_code")
    @Excel(name = "不动产证号", readConverterExp = "房=产证")
    private String property_deeds_code;

    /** 土地证发证日期 */
    @TableField("land_deeds_issue_date")
    @Excel(name = "土地证发证日期")
    private String land_deeds_issue_date;

    /** 土地到期日期 */
    @TableField("land_expired_date")
    @Excel(name = "土地到期日期")
    private String land_expired_date;

    /** 位置类型 */
    @TableField("location_type")
    @Excel(name = "位置类型")
    private String location_type;

    /** 是否有土地证 */
    @TableField("exist_land_deeds")
    @Excel(name = "是否有土地证")
    private String exist_land_deeds;

    /** 土地证起始时间 */
    @TableField("land_deeds_start_date")
    @Excel(name = "土地证起始时间")
    private String land_deeds_start_date;

    /** 土地证结束时间 */
    @TableField("land_deeds_end_date")
    @Excel(name = "土地证结束时间")
    private String land_deeds_end_date;

    /** 土地证类型 */
    @TableField("land_deeds_type")
    @Excel(name = "土地证类型")
    private String land_deeds_type;

    /** 房产总面积 */
    @TableField("property_area")
    @Excel(name = "房产总面积")
    private String property_area;

    /** 房产可出租面积 */
    @TableField("property_leasable_area")
    @Excel(name = "房产可出租面积")
    private String property_leasable_area;

    /** 地上总面积 */
    @TableField("ground_area")
    @Excel(name = "地上总面积")
    private String ground_area;

    /** 地下总面积 */
    @TableField("underground_area")
    @Excel(name = "地下总面积")
    private String underground_area;

    /** 房产有证面积 */
    @TableField("property_certified_area")
    @Excel(name = "房产有证面积")
    private String property_certified_area;

    /** 房产无证面积 */
    @TableField("property_uncertified_area")
    @Excel(name = "房产无证面积")
    private String property_uncertified_area;

    /** 土地总面积 */
    @TableField("land_area")
    @Excel(name = "土地总面积")
    private String land_area;

    /** 土地可出租面积 */
    @TableField("land_leasable_area")
    @Excel(name = "土地可出租面积")
    private String land_leasable_area;

    /** 土地有证面积 */
    @TableField("land_certified_area")
    @Excel(name = "土地有证面积")
    private String land_certified_area;

    /** 土地无证面积 */
    @TableField("land_uncertified_area")
    @Excel(name = "土地无证面积")
    private String land_uncertified_area;

    /** 是否有消防评估报告 */
    @TableField("exist_fire_assessment")
    @Excel(name = "是否有消防评估报告")
    private String exist_fire_assessment;

    /** 创建时间 */
    @TableField("create_time")
    private String create_time;

    /** 更新时间 */
    @TableField("update_time")
    private String update_time;

    /** 项目id */
    @TableField("proj_id")
    @Excel(name = "项目id")
    private String proj_id;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOut_id() {
        return out_id;
    }

    public void setOut_id(String out_id) {
        this.out_id = out_id;
    }

    public String getManage_corp_name() {
        return manage_corp_name;
    }

    public void setManage_corp_name(String manage_corp_name) {
        this.manage_corp_name = manage_corp_name;
    }

    public String getProj_name() {
        return proj_name;
    }

    public void setProj_name(String proj_name) {
        this.proj_name = proj_name;
    }

    public String getCategory_name() {
        return category_name;
    }

    public void setCategory_name(String category_name) {
        this.category_name = category_name;
    }

    public String getType_name() {
        return type_name;
    }

    public void setType_name(String type_name) {
        this.type_name = type_name;
    }

    public String getExist_fire_certificate() {
        return exist_fire_certificate;
    }

    public void setExist_fire_certificate(String exist_fire_certificate) {
        this.exist_fire_certificate = exist_fire_certificate;
    }

    public String getExist_dilapidated_building() {
        return exist_dilapidated_building;
    }

    public void setExist_dilapidated_building(String exist_dilapidated_building) {
        this.exist_dilapidated_building = exist_dilapidated_building;
    }

    public String getDilapidated_building_level() {
        return dilapidated_building_level;
    }

    public void setDilapidated_building_level(String dilapidated_building_level) {
        this.dilapidated_building_level = dilapidated_building_level;
    }

    public String getDilapidated_building_quantity() {
        return dilapidated_building_quantity;
    }

    public void setDilapidated_building_quantity(String dilapidated_building_quantity) {
        this.dilapidated_building_quantity = dilapidated_building_quantity;
    }

    public String getDilapidated_building_area() {
        return dilapidated_building_area;
    }

    public void setDilapidated_building_area(String dilapidated_building_area) {
        this.dilapidated_building_area = dilapidated_building_area;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLng() {
        return lng;
    }

    public void setLng(String lng) {
        this.lng = lng;
    }

    public String getProvince_name() {
        return province_name;
    }

    public void setProvince_name(String province_name) {
        this.province_name = province_name;
    }

    public String getCity_name() {
        return city_name;
    }

    public void setCity_name(String city_name) {
        this.city_name = city_name;
    }

    public String getDistrict_name() {
        return district_name;
    }

    public void setDistrict_name(String district_name) {
        this.district_name = district_name;
    }

    public String getStreet_name() {
        return street_name;
    }

    public void setStreet_name(String street_name) {
        this.street_name = street_name;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getInventory_area() {
        return inventory_area;
    }

    public void setInventory_area(String inventory_area) {
        this.inventory_area = inventory_area;
    }

    public String getAsset_code() {
        return asset_code;
    }

    public void setAsset_code(String asset_code) {
        this.asset_code = asset_code;
    }

    public String getPlanned_uses() {
        return planned_uses;
    }

    public void setPlanned_uses(String planned_uses) {
        this.planned_uses = planned_uses;
    }

    public String getPractical_uses() {
        return practical_uses;
    }

    public void setPractical_uses(String practical_uses) {
        this.practical_uses = practical_uses;
    }

    public String getBuilding_structure() {
        return building_structure;
    }

    public void setBuilding_structure(String building_structure) {
        this.building_structure = building_structure;
    }

    public String getGround_plies() {
        return ground_plies;
    }

    public void setGround_plies(String ground_plies) {
        this.ground_plies = ground_plies;
    }

    public String getUnderground_plies() {
        return underground_plies;
    }

    public void setUnderground_plies(String underground_plies) {
        this.underground_plies = underground_plies;
    }

    public String getFirst_floor_height() {
        return first_floor_height;
    }

    public void setFirst_floor_height(String first_floor_height) {
        this.first_floor_height = first_floor_height;
    }

    public String getOther_floor_height() {
        return other_floor_height;
    }

    public void setOther_floor_height(String other_floor_height) {
        this.other_floor_height = other_floor_height;
    }

    public String getReceiving_date() {
        return receiving_date;
    }

    public void setReceiving_date(String receiving_date) {
        this.receiving_date = receiving_date;
    }

    public String getProperty_status() {
        return property_status;
    }

    public void setProperty_status(String property_status) {
        this.property_status = property_status;
    }

    public String getYear_built() {
        return year_built;
    }

    public void setYear_built(String year_built) {
        this.year_built = year_built;
    }

    public String getProperty_detail() {
        return property_detail;
    }

    public void setProperty_detail(String property_detail) {
        this.property_detail = property_detail;
    }

    public String getProperty_corp_name() {
        return property_corp_name;
    }

    public void setProperty_corp_name(String property_corp_name) {
        this.property_corp_name = property_corp_name;
    }

    public String getProperty_deeds_code() {
        return property_deeds_code;
    }

    public void setProperty_deeds_code(String property_deeds_code) {
        this.property_deeds_code = property_deeds_code;
    }

    public String getLand_deeds_issue_date() {
        return land_deeds_issue_date;
    }

    public void setLand_deeds_issue_date(String land_deeds_issue_date) {
        this.land_deeds_issue_date = land_deeds_issue_date;
    }

    public String getLand_expired_date() {
        return land_expired_date;
    }

    public void setLand_expired_date(String land_expired_date) {
        this.land_expired_date = land_expired_date;
    }

    public String getLocation_type() {
        return location_type;
    }

    public void setLocation_type(String location_type) {
        this.location_type = location_type;
    }

    public String getExist_land_deeds() {
        return exist_land_deeds;
    }

    public void setExist_land_deeds(String exist_land_deeds) {
        this.exist_land_deeds = exist_land_deeds;
    }

    public String getLand_deeds_start_date() {
        return land_deeds_start_date;
    }

    public void setLand_deeds_start_date(String land_deeds_start_date) {
        this.land_deeds_start_date = land_deeds_start_date;
    }

    public String getLand_deeds_end_date() {
        return land_deeds_end_date;
    }

    public void setLand_deeds_end_date(String land_deeds_end_date) {
        this.land_deeds_end_date = land_deeds_end_date;
    }

    public String getLand_deeds_type() {
        return land_deeds_type;
    }

    public void setLand_deeds_type(String land_deeds_type) {
        this.land_deeds_type = land_deeds_type;
    }

    public String getProperty_area() {
        return property_area;
    }

    public void setProperty_area(String property_area) {
        this.property_area = property_area;
    }

    public String getProperty_leasable_area() {
        return property_leasable_area;
    }

    public void setProperty_leasable_area(String property_leasable_area) {
        this.property_leasable_area = property_leasable_area;
    }

    public String getGround_area() {
        return ground_area;
    }

    public void setGround_area(String ground_area) {
        this.ground_area = ground_area;
    }

    public String getUnderground_area() {
        return underground_area;
    }

    public void setUnderground_area(String underground_area) {
        this.underground_area = underground_area;
    }

    public String getProperty_certified_area() {
        return property_certified_area;
    }

    public void setProperty_certified_area(String property_certified_area) {
        this.property_certified_area = property_certified_area;
    }

    public String getProperty_uncertified_area() {
        return property_uncertified_area;
    }

    public void setProperty_uncertified_area(String property_uncertified_area) {
        this.property_uncertified_area = property_uncertified_area;
    }

    public String getLand_area() {
        return land_area;
    }

    public void setLand_area(String land_area) {
        this.land_area = land_area;
    }

    public String getLand_leasable_area() {
        return land_leasable_area;
    }

    public void setLand_leasable_area(String land_leasable_area) {
        this.land_leasable_area = land_leasable_area;
    }

    public String getLand_certified_area() {
        return land_certified_area;
    }

    public void setLand_certified_area(String land_certified_area) {
        this.land_certified_area = land_certified_area;
    }

    public String getLand_uncertified_area() {
        return land_uncertified_area;
    }

    public void setLand_uncertified_area(String land_uncertified_area) {
        this.land_uncertified_area = land_uncertified_area;
    }

    public String getExist_fire_assessment() {
        return exist_fire_assessment;
    }

    public void setExist_fire_assessment(String exist_fire_assessment) {
        this.exist_fire_assessment = exist_fire_assessment;
    }

    public String getCreate_time() {
        return create_time;
    }

    public void setCreate_time(String create_time) {
        this.create_time = create_time;
    }

    public String getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(String update_time) {
        this.update_time = update_time;
    }

    public String getProj_id() {
        return proj_id;
    }

    public void setProj_id(String proj_id) {
        this.proj_id = proj_id;
    }
}
