package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.RiskSignRecord;
import com.censoft.censoftrongtong.domain.dto.RiskSignRecordShowDto;
import com.censoft.censoftrongtong.service.IRiskSignRecordService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 签到签退记录Controller
 * 
 * @author ruoyi
 * @date 2023-09-19
 */
@RestController
@RequestMapping("/system/record")
public class RiskSignRecordController extends BaseController
{
    @Autowired
    private IRiskSignRecordService riskSignRecordService;

    /**
     * 查询签到签退记录列表
     */
    @PreAuthorize("@ss.hasPermi('system:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(RiskSignRecordShowDto riskSignRecordShowDto)
    {
        startPage();
        List<RiskSignRecordShowDto> list = riskSignRecordService.selectRiskSignRecordShowDtoList(riskSignRecordShowDto);
        return getDataTable(list);
    }

    /**
     * 导出签到签退记录列表
     */
    @PreAuthorize("@ss.hasPermi('system:record:export')")
    @Log(title = "签到签退记录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, RiskSignRecord riskSignRecord)
    {
        List<RiskSignRecord> list = riskSignRecordService.selectRiskSignRecordShowDtoList(riskSignRecord);
        ExcelUtil<RiskSignRecord> util = new ExcelUtil<RiskSignRecord>(RiskSignRecord.class);
        util.exportExcel(response, list, "签到签退记录数据");
    }

    /**
     * 获取签到签退记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:record:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(riskSignRecordService.selectRiskSignRecordById(id));
    }

    /**
     * 新增签到签退记录
     */
    @PreAuthorize("@ss.hasPermi('system:record:add')")
    @Log(title = "签到签退记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RiskSignRecord riskSignRecord)
    {
        return toAjax(riskSignRecordService.insertRiskSignRecord(riskSignRecord));
    }

    /**
     * 修改签到签退记录
     */
    @PreAuthorize("@ss.hasPermi('system:record:edit')")
    @Log(title = "签到签退记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RiskSignRecord riskSignRecord)
    {
        return toAjax(riskSignRecordService.updateRiskSignRecord(riskSignRecord));
    }

    /**
     * 删除签到签退记录
     */
    @PreAuthorize("@ss.hasPermi('system:record:remove')")
    @Log(title = "签到签退记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(riskSignRecordService.deleteRiskSignRecordByIds(ids));
    }
}
