package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.service.IRiskPlanExistingListService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 现有风险清单库Controller
 *
 * @author ruoyi
 * @date 2023-07-31
 */
@RestController
@RequestMapping("/system/risk/existing")
public class RiskPlanExistingListController extends BaseController
{
    @Autowired
    private IRiskPlanExistingListService riskPlanExistingListService;

    /**
     * 查询现有风险清单库列表
     */
//    @PreAuthorize("@ss.hasPermi('system:existing:list')")
    @GetMapping("/list")
    public TableDataInfo list(RiskPlanExistingList riskPlanExistingList)
    {
        startPage();
        List<RiskPlanExistingList> list = riskPlanExistingListService.selectRiskPlanExistingListList(riskPlanExistingList);
        return getDataTable(list);
    }

    /**
     * 导出现有风险清单库列表
     */
    @PreAuthorize("@ss.hasPermi('system:list:export')")
    @Log(title = "现有风险清单库", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, RiskPlanExistingList riskPlanExistingList)
    {
        List<RiskPlanExistingList> list = riskPlanExistingListService.selectRiskPlanExistingListList(riskPlanExistingList);
        ExcelUtil<RiskPlanExistingList> util = new ExcelUtil<RiskPlanExistingList>(RiskPlanExistingList.class);
        util.exportExcel(response, list, "现有风险清单库数据");
    }

    /**
     * 获取现有风险清单库详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:list:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(riskPlanExistingListService.selectRiskPlanExistingListById(id));
    }

    /**
     * 新增现有风险清单库
     */
    @PreAuthorize("@ss.hasPermi('system:list:add')")
    @Log(title = "现有风险清单库", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RiskPlanExistingList riskPlanExistingList)
    {
        return toAjax(riskPlanExistingListService.insertRiskPlanExistingList(riskPlanExistingList));
    }

    /**
     * 修改现有风险清单库
     */
    @PreAuthorize("@ss.hasPermi('system:list:edit')")
    @Log(title = "现有风险清单库", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RiskPlanExistingList riskPlanExistingList)
    {
        return toAjax(riskPlanExistingListService.updateRiskPlanExistingList(riskPlanExistingList));
    }

    /**
     * 删除现有风险清单库
     */
    @PreAuthorize("@ss.hasPermi('system:list:remove')")
    @Log(title = "现有风险清单库", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(riskPlanExistingListService.deleteRiskPlanExistingListByIds(ids));
    }
}

