package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.censoft.censoftrongtong.domain.CurrentRiskDetailAbnormal;
import com.censoft.censoftrongtong.service.ICurrentRiskDetailAbnormalService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 现状风险巡查异常信息Controller
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
@RestController
@RequestMapping("/risk/currentRiskAbnormal")
public class CurrentRiskDetailAbnormalController extends BaseController
{
    @Autowired
    private ICurrentRiskDetailAbnormalService currentRiskDetailAbnormalService;

    /**
     * 查询现状风险巡查异常信息列表
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskAbnormal:list')")
    @GetMapping("/list")
    public TableDataInfo list(CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        startPage();
        List<CurrentRiskDetailAbnormal> list = currentRiskDetailAbnormalService.selectCurrentRiskDetailAbnormalList(currentRiskDetailAbnormal);
        return getDataTable(list);
    }

    /**
     * 导出现状风险巡查异常信息列表
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskAbnormal:export')")
    @Log(title = "现状风险巡查异常信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        List<CurrentRiskDetailAbnormal> list = currentRiskDetailAbnormalService.selectCurrentRiskDetailAbnormalList(currentRiskDetailAbnormal);
        ExcelUtil<CurrentRiskDetailAbnormal> util = new ExcelUtil<CurrentRiskDetailAbnormal>(CurrentRiskDetailAbnormal.class);
        util.exportExcel(response, list, "现状风险巡查异常信息数据");
    }

    /**
     * 获取现状风险巡查异常信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskAbnormal:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(currentRiskDetailAbnormalService.selectCurrentRiskDetailAbnormalById(id));
    }

    /**
     * 新增现状风险巡查异常信息
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskAbnormal:add')")
    @Log(title = "现状风险巡查异常信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        return toAjax(currentRiskDetailAbnormalService.insertCurrentRiskDetailAbnormal(currentRiskDetailAbnormal));
    }

    /**
     * 修改现状风险巡查异常信息
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskAbnormal:edit')")
    @Log(title = "现状风险巡查异常信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        return toAjax(currentRiskDetailAbnormalService.updateCurrentRiskDetailAbnormal(currentRiskDetailAbnormal));
    }

    /**
     * 删除现状风险巡查异常信息
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskAbnormal:remove')")
    @Log(title = "现状风险巡查异常信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(currentRiskDetailAbnormalService.deleteCurrentRiskDetailAbnormalByIds(ids));
    }
}
