package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.RiskInherentList;
import com.github.yulichang.base.MPJBaseMapper;

import java.util.List;

/**
 * 固有风险清单库Mapper接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface RiskInherentListMapper extends  MPJBaseMapper<RiskInherentList>
{
    /**
     * 查询固有风险清单库
     * 
     * @param id 固有风险清单库主键
     * @return 固有风险清单库
     */
    public RiskInherentList selectRiskInherentListById(Long id);

    /**
     * 查询固有风险清单库列表
     * 
     * @param riskInherentList 固有风险清单库
     * @return 固有风险清单库集合
     */
    public List<RiskInherentList> selectRiskInherentListList(RiskInherentList riskInherentList);

    /**
     * 新增固有风险清单库
     * 
     * @param riskInherentList 固有风险清单库
     * @return 结果
     */
    public int insertRiskInherentList(RiskInherentList riskInherentList);

    /**
     * 修改固有风险清单库
     * 
     * @param riskInherentList 固有风险清单库
     * @return 结果
     */
    public int updateRiskInherentList(RiskInherentList riskInherentList);

    /**
     * 删除固有风险清单库
     * 
     * @param id 固有风险清单库主键
     * @return 结果
     */
    public int deleteRiskInherentListById(Long id);

    /**
     * 批量删除固有风险清单库
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteRiskInherentListByIds(Long[] ids);
}
