package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.RiskExistingList;
import com.github.yulichang.base.MPJBaseMapper;

import java.util.List;

/**
 * 现有风险清单库Mapper接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface RiskExistingListMapper extends  MPJBaseMapper<RiskExistingList>
{
    /**
     * 查询现有风险清单库
     * 
     * @param id 现有风险清单库主键
     * @return 现有风险清单库
     */
    public RiskExistingList selectRiskExistingListById(Long id);

    /**
     * 查询现有风险清单库列表
     * 
     * @param riskExistingList 现有风险清单库
     * @return 现有风险清单库集合
     */
    public List<RiskExistingList> selectRiskExistingListList(RiskExistingList riskExistingList);

    /**
     * 新增现有风险清单库
     * 
     * @param riskExistingList 现有风险清单库
     * @return 结果
     */
    public int insertRiskExistingList(RiskExistingList riskExistingList);

    /**
     * 修改现有风险清单库
     * 
     * @param riskExistingList 现有风险清单库
     * @return 结果
     */
    public int updateRiskExistingList(RiskExistingList riskExistingList);

    /**
     * 删除现有风险清单库
     * 
     * @param id 现有风险清单库主键
     * @return 结果
     */
    public int deleteRiskExistingListById(Long id);

    /**
     * 批量删除现有风险清单库
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteRiskExistingListByIds(Long[] ids);
}
