package com.censoft.censoftrongtong.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrol;
import com.censoft.censoftrongtong.domain.RiskExistingListPatrolVO;
import com.censoft.censoftrongtong.domain.req.CurrentRiskUserPatrolDetailUpdateStatusReqVO;
import com.censoft.censoftrongtong.service.ICurrentRiskUserPatrolService;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrolDetail;
import com.censoft.censoftrongtong.service.ICurrentRiskUserPatrolDetailService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 现状风险用户巡查明细Controller
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
@RestController
@AllArgsConstructor
@RequestMapping(value = {"/risk/currentRiskPatrolDetail","/app-api/risk/currentRiskPatrolDetail"})
public class CurrentRiskUserPatrolDetailController extends BaseController
{

    private ICurrentRiskUserPatrolDetailService currentRiskUserPatrolDetailService;
    private ICurrentRiskUserPatrolService currentRiskUserPatrolDetail;


    /**
     * 查询现状风险用户巡查明细列表
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskPatrolDetail:list')")
    @GetMapping("/list")
    public TableDataInfo list(CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail)
    {
        startPage();
        List<CurrentRiskUserPatrolDetail> list = currentRiskUserPatrolDetailService.selectCurrentRiskUserPatrolDetailList(currentRiskUserPatrolDetail);
        return getDataTable(list);
    }


    /**
     * 查询现状风险用户巡查明细列表
     */
    @GetMapping("/detailList")
     public TableDataInfo detailList(RiskExistingListPatrolVO query)
    {
        startPage();
        query.setUserId(getUserId());
        List<RiskExistingListPatrolVO> list = currentRiskUserPatrolDetailService.riskExistingLists(query);
        return getDataTable(list);
    }

    @ApiModelProperty("更改状态")
    @PostMapping("/updateStatus")
    public AjaxResult updateStatus(@RequestBody CurrentRiskUserPatrolDetailUpdateStatusReqVO reqVO)
    {
        //更新巡查信息为已巡查
        CurrentRiskUserPatrol currentRiskUserPatrol = currentRiskUserPatrolDetail.selectCurrentRiskUserPatrolById(Long.valueOf(reqVO.getPatrolId()));
        //状态 0 未巡查 1 已巡查 2 已请假 3 已过期
        currentRiskUserPatrol.setStatus("1");
        currentRiskUserPatrolDetail.updateCurrentRiskUserPatrol(currentRiskUserPatrol);
        //更新巡查明细信息
        List<CurrentRiskUserPatrolDetail> details = new ArrayList<>();
        List<Map<String,Object>> list = reqVO.getList();
        if(CollectionUtils.isEmpty(list)){
            return AjaxResult.success();
        }
        list.forEach(map ->{
            CurrentRiskUserPatrolDetail detail = new CurrentRiskUserPatrolDetail();
            detail.setId(Long.parseLong(String.valueOf(map.get("patrolDetailId"))));
            detail.setStatus(String.valueOf(map.get("patrolStatus")));
            details.add(detail);
        });
        currentRiskUserPatrolDetailService.updateBatchById(details);
        return AjaxResult.success();
    }


    /**
     * 导出现状风险用户巡查明细列表
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskPatrolDetail:export')")
    @Log(title = "现状风险用户巡查明细", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail)
    {
        List<CurrentRiskUserPatrolDetail> list = currentRiskUserPatrolDetailService.selectCurrentRiskUserPatrolDetailList(currentRiskUserPatrolDetail);
        ExcelUtil<CurrentRiskUserPatrolDetail> util = new ExcelUtil<CurrentRiskUserPatrolDetail>(CurrentRiskUserPatrolDetail.class);
        util.exportExcel(response, list, "现状风险用户巡查明细数据");
    }

    /**
     * 获取现状风险用户巡查明细详细信息
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskPatrolDetail:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(currentRiskUserPatrolDetailService.selectCurrentRiskUserPatrolDetailById(id));
    }

    /**
     * 新增现状风险用户巡查明细
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskPatrolDetail:add')")
    @Log(title = "现状风险用户巡查明细", businessType = BusinessType.INSERT)
    @PostMapping("save")
    public AjaxResult add(@RequestBody CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail)
    {
        return toAjax(currentRiskUserPatrolDetailService.insertCurrentRiskUserPatrolDetail(currentRiskUserPatrolDetail));
    }

    /**
     * 修改现状风险用户巡查明细
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskPatrolDetail:edit')")
    @Log(title = "现状风险用户巡查明细", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail)
    {
        return toAjax(currentRiskUserPatrolDetailService.updateCurrentRiskUserPatrolDetail(currentRiskUserPatrolDetail));
    }

    /**
     * 删除现状风险用户巡查明细
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskPatrolDetail:remove')")
    @Log(title = "现状风险用户巡查明细", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(currentRiskUserPatrolDetailService.deleteCurrentRiskUserPatrolDetailByIds(ids));
    }
}
