package com.censoft.censoftrongtong.enums;

public enum RiskPlanStatusType {
    /**
     * 任务发起
     */
    WAIT_START("WAIT_START"),
    /**
     * 风险评估
     */
    RUNNING("RUNNING"),
    /**
     * 评估审核
     */
    WAIT_FINISH("WAIT_APPROVE"),
    /**
     * 项目完成
     */
    FINISH("FINISH"),
    /**
     * 已退回
     */
    WAIT_ADJUST("WAIT_RETURN"),
    /**
     * 已撤销
     */
    REVOKE("REVOKE");

    private final String status;

    RiskPlanStatusType(String status) {
        this.status = status;
    }

    public String getStatus() {
        return status;
    }


    public static String getTitleByStatus(String status){
        switch (status){
            case "WAIT_START":
                return "任务发起";
            case "RUNNING":
                return "风险评估";
            case "WAIT_APPROVE":
                return "评估审核";
            case "FINISH":
                return "项目完成";
            case "WAIT_RETURN":
                return "已退回";
            case "REVOKE":
                return "已撤销";
        }
        return "";
    }
}
