package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.RiskPlanTask;

import java.util.List;

/**
 * 风险计划任务Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface IRiskPlanTaskService 
{
    /**
     * 查询风险计划任务
     * 
     * @param id 风险计划任务主键
     * @return 风险计划任务
     */
    public RiskPlanTask selectRiskPlanTaskById(Long id);

    /**
     * 查询风险计划任务列表
     * 
     * @param riskPlanTask 风险计划任务
     * @return 风险计划任务集合
     */
    public List<RiskPlanTask> selectRiskPlanTaskList(RiskPlanTask riskPlanTask);

    /**
     * 新增风险计划任务
     * 
     * @param riskPlanTask 风险计划任务
     * @return 结果
     */
    public int insertRiskPlanTask(RiskPlanTask riskPlanTask);

    /**
     * 修改风险计划任务
     * 
     * @param riskPlanTask 风险计划任务
     * @return 结果
     */
    public int updateRiskPlanTask(RiskPlanTask riskPlanTask);

    /**
     * 批量删除风险计划任务
     * 
     * @param ids 需要删除的风险计划任务主键集合
     * @return 结果
     */
    public int deleteRiskPlanTaskByIds(Long[] ids);

    /**
     * 删除风险计划任务信息
     * 
     * @param id 风险计划任务主键
     * @return 结果
     */
    public int deleteRiskPlanTaskById(Long id);
}
