package com.censoft.censoftrongtong.domain;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 风险计划对象 risk_plan
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class RiskPlan extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String name;

    /** 任务编号 */
    @Excel(name = "任务编号")
    private String no;

    /** 项目id */
    @Excel(name = "项目id")
    private Long projectId;

    /** 楼栋ids */
    @Excel(name = "楼栋ids")
    private String buildingIds;

    /** 创建人员id */
    @Excel(name = "创建人员id")
    private Long createUserId;

    /** 创建单位 */
    @Excel(name = "创建单位")
    private Long createDeptId;

    /** 评估小组id */
    @Excel(name = "评估小组id")
    private Long deptId;

    /** 负责人id */
    @Excel(name = "负责人id")
    private Long leaderUserId;

    /** 执行人员ids */
    @Excel(name = "执行人员ids")
    private String workUserIds;

    /** 审批人id */
    @Excel(name = "审批人id")
    private Long approveUserId;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 状态 */
    @Excel(name = "状态")
    private String status;


    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    /**
     * 项目名称
     */
    @TableField(exist = false)
    private String projectName;




}
