package com.ruoyi.framework.config;

import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

import javax.servlet.MultipartConfigElement;

/**
 * @author 周昊
 * @desc ...
 * @date 2023-06-28 14:54:58
 */
@Configuration
public class FileUploadConfig {

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(DataSize.ofMegabytes(10)); // 设置最大文件大小为10MB
        factory.setMaxRequestSize(DataSize.ofMegabytes(20)); // 设置最大请求大小为10MB
        return factory.createMultipartConfig();
    }
}
