package com.censoft.censoftrongtong.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import cn.hutool.poi.excel.cell.CellUtil;
import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.RiskPlanTask;
import com.censoft.censoftrongtong.domain.dto.*;
import com.censoft.censoftrongtong.domain.dto.statistics.*;
import com.censoft.censoftrongtong.enums.RiskPlanStatusType;
import com.censoft.censoftrongtong.mapper.RiskPlanInherentListMapper;
import com.censoft.censoftrongtong.mapper.RiskPlanMapper;
import com.censoft.censoftrongtong.mapper.RiskPlanTaskMapper;
import com.censoft.censoftrongtong.service.IRiskPlanInherentListService;
import com.censoft.censoftrongtong.service.IRiskPlanTaskService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.WordUtil;
import com.ruoyi.system.service.ISysUploadFileService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 固有风险清单库Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanInherentListServiceImpl
        extends MPJBaseServiceImpl<RiskPlanInherentListMapper, RiskPlanInherentList>
        implements IRiskPlanInherentListService {
    @Autowired
    private RiskPlanInherentListMapper riskPlanInherentListMapper;
    @Autowired
    private RiskPlanTaskMapper riskPlanTaskMapper;

    @Autowired
    private RiskPlanMapper riskPlanMapper;

    @Resource
    private ISysUploadFileService uploadFileService;

    @Resource
    private IRiskPlanTaskService riskPlanTaskService;


    @Override
    public Long getNationalRiskNum(Integer level,String areaName, Date beginTime,Long peojectId) {

        return riskPlanInherentListMapper.getNationalRiskNum(level,areaName, beginTime,peojectId);
    }

    @Override
    public List<RiskIndexRankingDto> getRiskIndexRanking(Integer level,String areaName) {

        return riskPlanInherentListMapper.getRiskIndexRanking(level,areaName);
    }

    @Override
    public LinkedHashMap<String, Long> getAnnualRiskStatistics(Integer level,String areaName) {

        return riskPlanInherentListMapper.getAnnualRiskStatistics(level,areaName);
    }

    @Override
    public List<RiskLevelStatisticsDto> getRiskLevelStatistics(Integer level,String areaName,Long projectId) {
        return riskPlanInherentListMapper.getRiskLevelStatistics(level,areaName,projectId);
    }

    @Override
    public List<AccidentTypeStatisticsDto> getAccidentTypeStatistics(Integer level,String areaName) {
        return riskPlanInherentListMapper.getAccidentTypeStatistics(level,areaName);
    }
    @Override
    public List<RiskProjectRankingDto> getRiskProjectRanking(Integer level,String areaName) {
        return riskPlanInherentListMapper.getRiskProjectRanking(level,areaName);
    }
    @Override
    public List<ProjectRiskInfoDto> getProjectRiskInfo( Long projectId, Long buildingId, Long floorId,String level) {
        return riskPlanInherentListMapper.getProjectRiskInfo(projectId,buildingId,floorId,level);
    }
    @Override
    public List<RiskMapStatisticsDto> getRiskMapStatistics(MapStatisticsQueryDto queryDto) {
        return riskPlanInherentListMapper.getRiskMapStatistics(queryDto);
    }


    /**
     * 新增固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    public boolean saveInherent(RiskPlanInherentList riskPlanInherentList) {
        /**
         * 解题思路
         * 1.判断当前任务状态是否待执行状态
         * 2.待执行修改执行状态变为已完成否则不操作
         * 3.改为已完成添加任务执行记录
         */
        RiskPlanTask riskPlanTask = riskPlanTaskMapper.getLastRiskPlanTaskByPlanId(riskPlanInherentList.getPlanId());
        //计划
        RiskPlan riskPlan = riskPlanMapper.selectRiskPlanById(riskPlanTask.getPlanId());
        if (riskPlanTask != null) {
            if (riskPlanTask.getTaskKey().equals("WAIT_START") && riskPlanTask.getStatus().equals("running")) {
                //修改任务状态
                riskPlanTask.setStatus("completed");
                riskPlanTask.setCompletedTime(new Date());
                int rs = riskPlanTaskMapper.updateRiskPlanTask(riskPlanTask);
                if (rs > -1) {//修改状态成功
                    System.out.println("修改状态成功");
                }
                //创建任务执行状态
                RiskPlanTask riskPlanTask1 = new RiskPlanTask();
                riskPlanTask1.setPlanId(riskPlanTask.getPlanId());
                riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
                riskPlanTask1.setTaskKey(RiskPlanStatusType.RUNNING.getStatus());
                riskPlanTask1.setTaskName(RiskPlanStatusType.RUNNING.getTitle());
                riskPlanTask1.setStatus("running");
                riskPlanTask1.setStartTime(new Date());
                riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);
            }
        }
        riskPlanInherentList.setCreateTime(DateUtils.getNowDate());
        riskPlanInherentList.setDelFlag("0");//部分风险模版导入保存delflag会变成1导致数据丢失，原因未找到
//        return riskPlanInherentListMapper.insert(riskPlanInherentList)>0;
        return saveOrUpdate(riskPlanInherentList);
    }

    /**
     * 修改固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public boolean updateById(RiskPlanInherentList riskPlanInherentList) {
        /**
         * 解题思路
         * 1.判断当前任务状态是否待执行状态
         * 2.待执行修改执行状态变为已完成否则不操作
         * 3.改为已完成添加任务执行记录
         */
        RiskPlanTask riskPlanTask = riskPlanTaskMapper.getLastRiskPlanTaskByPlanId(riskPlanInherentList.getPlanId());
        //计划
        RiskPlan riskPlan = riskPlanMapper.selectRiskPlanById(riskPlanTask.getPlanId());
        if (riskPlanTask != null) {
            if (riskPlanTask.getTaskKey().equals("WAIT_START") && riskPlanTask.getStatus().equals("running")) {
                //修改任务状态
                riskPlanTask.setStatus("completed");
                riskPlanTask.setCompletedTime(new Date());
                int rs = riskPlanTaskMapper.updateRiskPlanTask(riskPlanTask);
                if (rs > -1) {//修改状态成功
                    System.out.println("修改状态成功");
                }
                //创建任务执行状态
                RiskPlanTask riskPlanTask1 = new RiskPlanTask();
                riskPlanTask1.setPlanId(riskPlanTask.getPlanId());
                riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
                riskPlanTask1.setTaskKey(RiskPlanStatusType.RUNNING.getStatus());
                riskPlanTask1.setTaskName(RiskPlanStatusType.RUNNING.getTitle());
                riskPlanTask1.setStatus("running");
                riskPlanTask1.setStartTime(new Date());
                riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);
            }
        }
        riskPlanInherentList.setUpdateTime(DateUtils.getNowDate());
        return riskPlanInherentListMapper.updateById(riskPlanInherentList) > 0;
    }

    /**
     * 删除固有风险清单库信息
     *
     * @param entity 固有风险清单库主键
     * @return 结果
     */
    @Override
    public boolean removeById(RiskPlanInherentList entity) {
        /**
         * 解题思路
         * 1.判断当前任务状态是否待执行状态
         * 2.待执行修改执行状态变为已完成否则不操作
         * 3.改为已完成添加任务执行记录
         */
        RiskPlanInherentList riskPlanInherentList = riskPlanInherentListMapper.selectById(entity.getId());
        RiskPlanTask riskPlanTask = riskPlanTaskMapper.getLastRiskPlanTaskByPlanId(riskPlanInherentList.getPlanId());
        //计划
        RiskPlan riskPlan = riskPlanMapper.selectRiskPlanById(riskPlanTask.getPlanId());
        if (riskPlanTask != null) {
            if (riskPlanTask.getTaskKey().equals("WAIT_START") && riskPlanTask.getStatus().equals("running")) {
                //修改任务状态
                riskPlanTask.setStatus("completed");
                riskPlanTask.setCompletedTime(new Date());
                int rs = riskPlanTaskMapper.updateRiskPlanTask(riskPlanTask);
                if (rs > -1) {//修改状态成功
                    System.out.println("修改状态成功");
                }
                //创建任务执行状态
                RiskPlanTask riskPlanTask1 = new RiskPlanTask();
                riskPlanTask1.setPlanId(riskPlanTask.getPlanId());
                riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
                riskPlanTask1.setTaskKey(RiskPlanStatusType.RUNNING.getStatus());
                riskPlanTask1.setTaskName(RiskPlanStatusType.RUNNING.getTitle());
                riskPlanTask1.setStatus("running");
                riskPlanTask1.setStartTime(new Date());
                riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);
            }
        }
        return riskPlanInherentListMapper.deleteById(entity.getId()) > 0;
    }

    @Override
    public List<RiskPlanAppInherentListDto> getInherentListByPlanId(Long projectId, Long buildingId, Long floorId, Long roomId) {
        return riskPlanInherentListMapper.getInherentListByPlanId(projectId, buildingId, floorId, roomId);
    }

    @Override
    public Boolean saveRiskInherentListSaveDto(RiskInherentListSaveDto saveDto) {
        RiskPlanInherentList inherentList = new RiskPlanInherentList();
        BeanUtils.copyProperties(saveDto, inherentList);
        return saveInherent(inherentList);
    }

    @Override
    public RiskPlanAppInherentListDetailsDto getRiskPlanAppInherentListDetailsDtoByInherentId(Long inherentId) {
        RiskPlanAppInherentListDetailsDto dto = riskPlanInherentListMapper.getRiskPlanAppInherentListDetailsDtoByInherentId(inherentId);

        //风险源照片
        if (!StrUtil.hasEmpty(dto.getPictureFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getPictureFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setPictureFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //工程技术措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresProjectFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresProjectFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresProjectFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //管理措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresAdministrationFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresAdministrationFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresAdministrationFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //应急处置措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresEmergencyFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresEmergencyFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresEmergencyFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        return dto;
    }

    @Override
    public List<RiskPlanAppExistingListDto> getExistingListByInherentId(Long inherentId) {
        return riskPlanInherentListMapper.getExistingListByInherentId(inherentId);
    }

    @Override
    public RiskNotificationExportWordDto getRiskNotificationExportWordDto(Long inherentId) {
        RiskNotificationExportWordDto dto = riskPlanInherentListMapper.getRiskNotificationExportWordDto(inherentId);
        if (StrUtil.isNotBlank(dto.getSafetyWarningSigns())){
            List<HashMap<String, String>> safetyWarningSignsList = Arrays.stream(dto.getSafetyWarningSigns().split(","))
                    .map(sign ->{
                        HashMap<String, String> map = new HashMap<>();
                        map.put("url",WordUtil.getImageStr("D:\\ruoyi\\uploadPath\\upload\\警告标志\\" + sign + ".png"));
                        return map;
                    }).collect(Collectors.toList());
            dto.setSafetyWarningSignsList(safetyWarningSignsList);
        }else {
            dto.setSafetyWarningSignsList(new ArrayList<>());
        }
        return dto;
    }

    @Override
    public void exportPlanInherentList(HttpServletResponse response,List<RiskInherentListExportDto> dtos)
            throws IOException {
        ExcelWriter writer = ExcelUtil.getWriter();
        //创建HSSFWorkbook对象(excel的文档对象)
        Workbook workbook = writer.getWorkbook();

        //合并单元格后的标题行，使用默认标题样式
        //序号
        writer.merge(0, 2, 0, 0, "序号", true);
        //项目信息
        writer.merge(0, 0, 1, 5, "项目信息", true);
        writer.merge(1, 2, 1, 1, "区域公司", true);
        writer.merge(1, 2, 2, 2, "项目名称", true);
        writer.merge(1, 2, 3, 3, "所属城市", true);
        writer.merge(1, 2, 4, 4, "项目业态", true);
        writer.merge(1, 2, 5, 5, "项目类型", true);
        //项目风险清单
        writer.merge(0, 0, 6, 11, "项目风险清单", true);
        writer.merge(1, 1, 6, 7, "固有风险", true);
        writer.merge(1, 1, 8, 9, "现有风险", true);
        Cell cell62 = writer.getOrCreateCell(6, 2);
        CellUtil.setCellValue(cell62, "危险源名称", writer.getHeadCellStyle());
        Cell cell72 = writer.getOrCreateCell(7, 2);
        CellUtil.setCellValue(cell72, "风险等级", writer.getHeadCellStyle());
        Cell cell82 = writer.getOrCreateCell(8, 2);
        CellUtil.setCellValue(cell82, "危险源名称", writer.getHeadCellStyle());
        Cell cell92 = writer.getOrCreateCell(9, 2);
        CellUtil.setCellValue(cell92, "风险等级", writer.getHeadCellStyle());
        writer.merge(1, 2, 10, 10, "风险点位置", true);
        writer.merge(1, 2, 11, 11, "可能导致的事故后果", true);
        //项目整体风险等级
        writer.merge(0, 0, 12, 13, "项目整体风险等级", true);
        writer.merge(1, 2, 12, 12, "固有风险", true);
        writer.merge(1, 2, 13, 13, "现状风险", true);
        //风险管控
        writer.merge(0, 0, 14, 18, "风险管控", true);
        writer.merge(1, 2, 14, 14, "应采取的管控措施", true);
        writer.merge(1, 2, 15, 15, "已采取的管控措施", true);
        writer.merge(1, 1, 16, 18, "分级管控", true);
        Cell cell162 = writer.getOrCreateCell(16, 2);
        CellUtil.setCellValue(cell162, "管控责任单位", writer.getHeadCellStyle());
        Cell cell172 = writer.getOrCreateCell(17, 2);
        CellUtil.setCellValue(cell172, "管控责任人", writer.getHeadCellStyle());
        Cell cell182 = writer.getOrCreateCell(18, 2);
        CellUtil.setCellValue(cell182, "人员联系方式", writer.getHeadCellStyle());
        //重大危险源管理
        writer.merge(0, 0, 19, 21, "重大危险源管理", true);
        writer.merge(1, 2, 19, 19, "是否存在重大危险源", true);
        writer.merge(1, 2, 20, 20, "重大危险源名称", true);
        writer.merge(1, 2, 21, 21, "重大危险源描述", true);
        //判定依据
        writer.merge(0, 2, 22, 22, "判定依据", true);


        //数据
        for (int i = 0; i < dtos.size(); i++) {
            RiskInherentListExportDto dto = dtos.get(i);
            //项目信息
            {
                Cell celli0 = writer.getOrCreateCell(0, i+3);
                CellUtil.setCellValue(celli0, i+1, writer.getCellStyle());

                Cell celli1 = writer.getOrCreateCell(1, i+3);
                CellUtil.setCellValue(celli1, dto.getDeptName(), writer.getCellStyle());

                Cell celli2 = writer.getOrCreateCell(2, i+3);
                CellUtil.setCellValue(celli2, dto.getProjectName(), writer.getCellStyle());

                Cell celli3 = writer.getOrCreateCell(3, i+3);
                CellUtil.setCellValue(celli3, dto.getCity(), writer.getCellStyle());

                Cell celli4 = writer.getOrCreateCell(4, i+3);
                CellUtil.setCellValue(celli4, dto.getBusinessFormat(), writer.getCellStyle());

                Cell celli5 = writer.getOrCreateCell(5, i+3);
                CellUtil.setCellValue(celli5, dto.getType(), writer.getCellStyle());
            }
            //项目风险清单
            {
                Cell celli6 = writer.getOrCreateCell(6, i+3);
                CellUtil.setCellValue(celli6, dto.getInherentName(), writer.getCellStyle());

                Cell celli7 = writer.getOrCreateCell(7, i+3);
                CellUtil.setCellValue(celli7, dto.getInherentLevel(), writer.getCellStyle());

                Cell celli8 = writer.getOrCreateCell(8, i+3);
                CellUtil.setCellValue(celli8, dto.getExistingName(), writer.getCellStyle());

                Cell celli9 = writer.getOrCreateCell(9, i+3);
                CellUtil.setCellValue(celli9, dto.getExistingLevel(), writer.getCellStyle());

                Cell celli10 = writer.getOrCreateCell(10, i+3);
                CellUtil.setCellValue(celli10, dto.getPresenceLocation(), writer.getCellStyle());

                Cell celli11 = writer.getOrCreateCell(11, i+3);
                CellUtil.setCellValue(celli11, dto.getListType(), writer.getCellStyle());
            }
            //项目整体风险等级
            {
                Cell celli12 = writer.getOrCreateCell(12, i+3);
                CellUtil.setCellValue(celli12, dto.getInherentProjectLevel(), writer.getCellStyle());

                Cell celli13 = writer.getOrCreateCell(13, i+3);
                CellUtil.setCellValue(celli13, dto.getExistingProjectLevel(), writer.getCellStyle());
            }
            //风险管控
            {
                Cell celli14 = writer.getOrCreateCell(14, i+3);
                CellUtil.setCellValue(celli14, dto.getInherentMeasuresAdministration(), writer.getCellStyle());

                Cell celli15 = writer.getOrCreateCell(15, i+3);
                CellUtil.setCellValue(celli15, dto.getExistingMeasuresAdministration(), writer.getCellStyle());

                Cell celli16 = writer.getOrCreateCell(16, i+3);
                CellUtil.setCellValue(celli16, dto.getMeasuresDeptName(), writer.getCellStyle());

                Cell celli17 = writer.getOrCreateCell(17, i+3);
                CellUtil.setCellValue(celli17, dto.getMeasuresUserName(), writer.getCellStyle());

                Cell celli18 = writer.getOrCreateCell(18, i+3);
                CellUtil.setCellValue(celli18, dto.getMeasuresUserPhone(), writer.getCellStyle());
            }
            //重大危险源管理
            {
                Cell celli19 = writer.getOrCreateCell(19, i+3);
                CellUtil.setCellValue(celli19, dto.getMajorHazardSource(), writer.getCellStyle());

                Cell celli20 = writer.getOrCreateCell(20, i+3);
                CellUtil.setCellValue(celli20, dto.getHazardSourceName(), writer.getCellStyle());

                Cell celli21 = writer.getOrCreateCell(21, i+3);
                CellUtil.setCellValue(celli21, dto.getMajorHazardDescription(), writer.getCellStyle());

                Cell celli22 = writer.getOrCreateCell(22, i+3);
                CellUtil.setCellValue(celli22, dto.getReferenceBasis(), writer.getCellStyle());
            }

        }


        String filename = URLEncoder.encode("项目风险清单表.xls", "UTF-8");
        //输出Excel文件
        OutputStream output=response.getOutputStream();
        response.reset();
        response.setHeader("Content-disposition", "attachment; filename="+filename+"");
        response.setContentType("application/msexcel");
        workbook.write(output);
        output.close();
    }

    @Override
    public List<RiskInherentListExportDto> getPlanInherentList(RiskInherentListExportDto riskInherentListExportDto) {
        return riskPlanInherentListMapper.getPlanInherentList(riskInherentListExportDto);
    }


    /**
     * 查询固有风险清单库
     *
     * @param id 固有风险清单库主键
     * @return 固有风险清单库
     */
    @Override
    public RiskPlanInherentList selectRiskPlanInherentListById(Long id)
    {
        return riskPlanInherentListMapper.selectRiskPlanInherentListById(id);
    }

    /**
     * 查询固有风险清单库列表
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 固有风险清单库
     */
    @Override
    public List<RiskPlanInherentList> selectRiskPlanInherentListList(RiskPlanInherentList riskPlanInherentList)
    {
        return riskPlanInherentListMapper.selectRiskPlanInherentListList(riskPlanInherentList);
    }

    /**
     * 新增固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int insertRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList)
    {
        riskPlanInherentList.setCreateTime(DateUtils.getNowDate());
        return riskPlanInherentListMapper.insertRiskPlanInherentList(riskPlanInherentList);
    }

    /**
     * 修改固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int updateRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList)
    {
        riskPlanInherentList.setUpdateTime(DateUtils.getNowDate());
        return riskPlanInherentListMapper.updateRiskPlanInherentList(riskPlanInherentList);
    }

    /**
     * 批量删除固有风险清单库
     *
     * @param ids 需要删除的固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanInherentListByIds(Long[] ids)
    {
        return riskPlanInherentListMapper.deleteRiskPlanInherentListByIds(ids);
    }

    /**
     * 删除固有风险清单库信息
     *
     * @param id 固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanInherentListById(Long id)
    {
        return riskPlanInherentListMapper.deleteRiskPlanInherentListById(id);
    }






}
