package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.censoft.censoftrongtong.domain.RiskLevelProportion;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.censoft.censoftrongtong.mapper.RiskLevelProportionMapper;
import com.censoft.censoftrongtong.service.IRiskLevelProportionService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 风险等级占比和系数Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
@Service
public class RiskLevelProportionServiceImpl extends MPJBaseServiceImpl<RiskLevelProportionMapper, RiskLevelProportion> implements IRiskLevelProportionService
{
    @Autowired
    private RiskLevelProportionMapper riskLevelProportionMapper;

    /**
     * 查询风险等级占比和系数
     * 
     * @param id 风险等级占比和系数主键
     * @return 风险等级占比和系数
     */
    @Override
    public RiskLevelProportion selectRiskLevelProportionById(Long id)
    {
        return riskLevelProportionMapper.selectRiskLevelProportionById(id);
    }

    /**
     * 查询风险等级占比和系数列表
     * 
     * @param riskLevelProportion 风险等级占比和系数
     * @return 风险等级占比和系数
     */
    @Override
    public List<RiskLevelProportion> selectRiskLevelProportionList(RiskLevelProportion riskLevelProportion)
    {
        return riskLevelProportionMapper.selectRiskLevelProportionList(riskLevelProportion);
    }

    /**
     * 新增风险等级占比和系数
     * 
     * @param riskLevelProportion 风险等级占比和系数
     * @return 结果
     */
    @Override
    public int insertRiskLevelProportion(RiskLevelProportion riskLevelProportion)
    {
        riskLevelProportion.setCreateTime(DateUtils.getNowDate());
        return riskLevelProportionMapper.insertRiskLevelProportion(riskLevelProportion);
    }

    /**
     * 修改风险等级占比和系数
     * 
     * @param riskLevelProportion 风险等级占比和系数
     * @return 结果
     */
    @Override
    public int updateRiskLevelProportion(RiskLevelProportion riskLevelProportion)
    {
        riskLevelProportion.setUpdateTime(DateUtils.getNowDate());
        return riskLevelProportionMapper.updateRiskLevelProportion(riskLevelProportion);
    }

    /**
     * 批量删除风险等级占比和系数
     * 
     * @param ids 需要删除的风险等级占比和系数主键
     * @return 结果
     */
    @Override
    public int deleteRiskLevelProportionByIds(Long[] ids)
    {
        return riskLevelProportionMapper.deleteRiskLevelProportionByIds(ids);
    }

    /**
     * 删除风险等级占比和系数信息
     * 
     * @param id 风险等级占比和系数主键
     * @return 结果
     */
    @Override
    public int deleteRiskLevelProportionById(Long id)
    {
        return riskLevelProportionMapper.deleteRiskLevelProportionById(id);
    }
}
