package com.censoft.censoftrongtong.service.impl;

import java.util.*;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.censoft.censoftrongtong.domain.InfoAssets;
import com.censoft.censoftrongtong.domain.InfoLedger;
import com.censoft.censoftrongtong.domain.LedgerBuilding;
import com.censoft.censoftrongtong.domain.LedgerProject;
import com.censoft.censoftrongtong.domain.dto.InfoResultDto;
import com.censoft.censoftrongtong.mapper.InfoAssetsMapper;
import com.censoft.censoftrongtong.mapper.LedgerBuildingMapper;
import com.censoft.censoftrongtong.service.IInfoAssetsService;
import com.censoft.censoftrongtong.service.ILedgerBuildingService;
import com.censoft.censoftrongtong.service.ILedgerProjectService;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.github.yulichang.base.MPJBaseServiceImpl;

import javax.annotation.Resource;

/**
 * 数据中台资产数据Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-10-07
 */
@Service
public class InfoAssetsServiceImpl extends MPJBaseServiceImpl<InfoAssetsMapper, InfoAssets> implements IInfoAssetsService
{
    @Autowired
    private InfoAssetsMapper infoAssetsMapper;

    @Resource
    private ILedgerBuildingService ledgerBuildingService;

    @Resource
    private ILedgerProjectService ledgerProjectService;

    @Resource
    private LedgerBuildingMapper ledgerBuildingMapper;

    /**
     * 查询数据中台资产数据
     * 
     * @param id 数据中台资产数据主键
     * @return 数据中台资产数据
     */
    @Override
    public InfoAssets selectInfoAssetsById(String id)
    {
        return infoAssetsMapper.selectInfoAssetsById(id);
    }

    /**
     * 查询数据中台资产数据列表
     * 
     * @param infoAssets 数据中台资产数据
     * @return 数据中台资产数据
     */
    @Override
    public List<InfoAssets> selectInfoAssetsList(InfoAssets infoAssets)
    {
        return infoAssetsMapper.selectInfoAssetsList(infoAssets);
    }

    /**
     * 新增数据中台资产数据
     * 
     * @param infoAssets 数据中台资产数据
     * @return 结果
     */
    @Override
    public int insertInfoAssets(InfoAssets infoAssets)
    {
        return infoAssetsMapper.insertInfoAssets(infoAssets);
    }

    /**
     * 修改数据中台资产数据
     * 
     * @param infoAssets 数据中台资产数据
     * @return 结果
     */
    @Override
    public int updateInfoAssets(InfoAssets infoAssets)
    {
        return infoAssetsMapper.updateInfoAssets(infoAssets);
    }

    /**
     * 批量删除数据中台资产数据
     * 
     * @param ids 需要删除的数据中台资产数据主键
     * @return 结果
     */
    @Override
    public int deleteInfoAssetsByIds(String[] ids)
    {
        return infoAssetsMapper.deleteInfoAssetsByIds(ids);
    }

    /**
     * 删除数据中台资产数据信息
     * 
     * @param id 数据中台资产数据主键
     * @return 结果
     */
    @Override
    public int deleteInfoAssetsById(String id)
    {
        return infoAssetsMapper.deleteInfoAssetsById(id);
    }


    @Override
    public String saveOrUpdateByHttp() {
        //获取全部数据
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("create_time", DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss"));
        paramMap.put("update_time", DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss"));
        paramMap.put("pageSize", "1");
        paramMap.put("pageNum", "1");
        //链式构建请求
        String result = HttpRequest.get("http://101.36.148.173:17027/api/risk/assets_info")
                .header("X-HW-ID", "rpa.ioc.301test")//头信息，多个头信息多次调用此方法即可
                .header("X-HW-APPKEY", "V6Ms/P7SvsFN/WdhFYgxrA==")
                .form(paramMap)//表单内容
                .timeout(20000)//超时，毫秒
                .execute().body();
        InfoResultDto infoResultDto = JSONObject.parseObject(result, InfoResultDto.class);

        String total = infoResultDto.getTotal();

        Integer totalNumber = Integer.valueOf(total);
        int totalNum = totalNumber / 100 + 1;
        for (int i = 1; i <= totalNum; i++) {
            paramMap.put("pageSize", "100");
            paramMap.put("pageNum", i);

            //链式构建请求
            result = HttpRequest.get("http://101.36.148.173:17027/api/risk/assets_info")
                    .header("X-HW-ID", "rpa.ioc.301test")//头信息，多个头信息多次调用此方法即可
                    .header("X-HW-APPKEY", "V6Ms/P7SvsFN/WdhFYgxrA==")
                    .form(paramMap)//表单内容
                    .timeout(20000)//超时，毫秒
                    .execute().body();
            infoResultDto = JSONObject.parseObject(result, InfoResultDto.class);
            List<InfoAssets> infoAssets = JSONArray.parseArray(infoResultDto.getData(), InfoAssets.class);
            saveOrUpdateBatch(infoAssets);

            List<LedgerProject> ledgerProjects = ledgerProjectService.selectLedgerProjectList(new LedgerProject());
            List<LedgerBuilding> ledgerBuildings = ledgerBuildingService.selectLedgerBuildingList(new LedgerBuilding());
            infoAssets.forEach(infoAsset -> {
                Optional<LedgerBuilding> first = ledgerBuildings.stream().filter(ledgerBuilding -> ledgerBuilding.getName().equals(infoAsset.getName())).findFirst();
                if (first.isPresent()) {
                    //关联id
                    LedgerBuilding ledgerBuilding = first.get();
                    ledgerBuilding.setInfoAssetsId(infoAsset.getId());
                    ledgerBuildingMapper.updateLedgerBuilding(ledgerBuilding);
                } else {
                    //新建
                    LedgerBuilding ledgerBuilding = new LedgerBuilding();
                    Optional<LedgerProject> first1 = ledgerProjects.stream().filter(ledgerProject -> ledgerProject.getInfoAssetsId()
                            .equals(infoAsset.getId())).findFirst();
                    if (first1.isPresent()) {
                        LedgerProject ledgerProject = first1.get();
                        ledgerBuilding.setDeptId(ledgerProject.getDeptId());
                        ledgerBuilding.setProjectId(ledgerProject.getId());
                    }

                    ledgerBuilding.setInfoAssetsId(infoAsset.getId());
                    ledgerBuilding.setName(infoAsset.getName());
                    ledgerBuilding.setType(infoAsset.getType_name());

                    if (NumberUtil.isInteger(infoAsset.getGround_plies())){
                        ledgerBuilding.setGroundFloor(Integer.valueOf(infoAsset.getGround_plies()));
                    }else {
                        ledgerBuilding.setGroundFloor(0);
                    }
                    if (NumberUtil.isInteger(infoAsset.getUnderground_plies())){
                        ledgerBuilding.setUndergroundFloor(Integer.valueOf(infoAsset.getUnderground_plies()));
                    }else {
                        ledgerBuilding.setUndergroundFloor(0);
                    }
                    ledgerBuilding.setFloor(ledgerBuilding.getGroundFloor()+ ledgerBuilding.getUndergroundFloor()+"");
                    ledgerBuilding.setUseto(infoAsset.getType_name());
                    ledgerBuilding.setCity(infoAsset.getCity_name());
                    ledgerBuilding.setAddress(infoAsset.getName());
                    ledgerBuilding.setStatus("0");
                    ledgerBuilding.setDelFlag("0");
                    ledgerBuildingService.save(ledgerBuilding);
                }
            });
        }

        return result;
    }
}
