package com.censoft.censoftrongtong.service.impl;

import com.censoft.censoftrongtong.service.IBacklogInfoService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.BacklogInfo;
import com.ruoyi.system.mapper.BacklogInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 待办信息Service业务层处理
 *
 * @author ruoyi
 * @date 2024-01-09
 */
@Service
public class BacklogInfoServiceImpl extends MPJBaseServiceImpl<BacklogInfoMapper, BacklogInfo> implements IBacklogInfoService {
    @Autowired
    private BacklogInfoMapper backlogInfoMapper;

    /**
     * 查询待办信息
     *
     * @param id 待办信息主键
     * @return 待办信息
     */
    @Override
    public BacklogInfo selectBacklogInfoById(String id) {
        return backlogInfoMapper.selectBacklogInfoById(id);
    }

    /**
     * 查询待办信息列表
     *
     * @param backlogInfo 待办信息
     * @return 待办信息
     */
    @Override
    public List<BacklogInfo> selectBacklogInfoList(BacklogInfo backlogInfo) {
        return backlogInfoMapper.selectBacklogInfoList(backlogInfo);
    }

    /**
     * 查询待办未读信息数量
     */
    @Override
    public int selectUnReadCount(String loginName, String app_url, String menu_url) {
        return backlogInfoMapper.selectUnReadCount(loginName, app_url, menu_url);
    }


    @Override
    public Map<String, Integer> getStatusCount(String loginName, String beginTime, String endTime, String keyword) {
        return backlogInfoMapper.getStatusCount(loginName, beginTime, endTime, keyword);
    }

    /**
     * 清除未读
     */
    @Override
    public boolean updateChangeStatus(String loginName) {
        return backlogInfoMapper.updateChangeStatus(loginName);
    }


    /**
     * 新增待办信息
     *
     * @param backlogInfo 待办信息
     * @return 结果
     */
    @Override
    public int insertBacklogInfo(BacklogInfo backlogInfo) {
        backlogInfo.setCreateTime(DateUtils.getNowDate());
        return backlogInfoMapper.insertBacklogInfo(backlogInfo);
    }

    /**
     * 修改待办信息
     *
     * @param backlogInfo 待办信息
     * @return 结果
     */
    @Override
    public int updateBacklogInfo(BacklogInfo backlogInfo) {
        backlogInfo.setUpdateTime(DateUtils.getNowDate());
        return backlogInfoMapper.updateBacklogInfo(backlogInfo);
    }

    /**
     * 批量删除待办信息
     *
     * @param ids 需要删除的待办信息主键
     * @return 结果
     */
    @Override
    public int deleteBacklogInfoByIds(String[] ids) {
        return backlogInfoMapper.deleteBacklogInfoByIds(ids);
    }

    /**
     * 删除待办信息信息
     *
     * @param id 待办信息主键
     * @return 结果
     */
    @Override
    public int deleteBacklogInfoById(String id) {
        return backlogInfoMapper.deleteBacklogInfoById(id);
    }
}
