package com.censoft.censoftrongtong.controller;

import com.censoft.censoftrongtong.domain.CurrentRiskPostList;
import com.censoft.censoftrongtong.service.ICurrentRiskPostListService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 现状风险岗位用户巡查清单Controller
 * 
 * @author bobbao
 * @date 2023-12-07
 */
@RestController
@RequestMapping(value = {"/risk/riskPostList", "/app-api/risk/riskPostList"})
public class CurrentRiskPostListController extends BaseController
{
    @Autowired
    private ICurrentRiskPostListService currentRiskPostListService;

    /**
     * 查询现状风险岗位用户巡查清单列表
     */
    @GetMapping("/list")
    public TableDataInfo list(CurrentRiskPostList currentRiskPostList)
    {
        startPage();
        List<CurrentRiskPostList> list = currentRiskPostListService.selectCurrentRiskPostListList(currentRiskPostList);
        return getDataTable(list);
    }

    @GetMapping("/list2")
    public TableDataInfo list2(CurrentRiskPostList currentRiskPostList)
    {
        startPage();
        List<CurrentRiskPostList> list = currentRiskPostListService.selectCurrentRiskPostListList2(currentRiskPostList);
        return getDataTable(list);
    }

    /**
     * 导出现状风险岗位用户巡查清单列表
     */
    @PreAuthorize("@ss.hasPermi('system:riskPostList:export')")
    @Log(title = "现状风险岗位用户巡查清单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CurrentRiskPostList currentRiskPostList)
    {
        List<CurrentRiskPostList> list = currentRiskPostListService.selectCurrentRiskPostListList(currentRiskPostList);
        ExcelUtil<CurrentRiskPostList> util = new ExcelUtil<CurrentRiskPostList>(CurrentRiskPostList.class);
        util.exportExcel(response, list, "现状风险岗位用户巡查清单数据");
    }

    /**
     * 获取现状风险岗位用户巡查清单详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:riskPostList:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(currentRiskPostListService.selectCurrentRiskPostListById(id));
    }

    /**
     * 新增现状风险岗位用户巡查清单
     */
    @PreAuthorize("@ss.hasPermi('system:riskPostList:add')")
    @Log(title = "现状风险岗位用户巡查清单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody CurrentRiskPostList currentRiskPostList)
    {
        return toAjax(currentRiskPostListService.insertCurrentRiskPostList(currentRiskPostList));
    }

    /**
     * 修改现状风险岗位用户巡查清单
     */
    @PreAuthorize("@ss.hasPermi('system:riskPostList:edit')")
    @Log(title = "现状风险岗位用户巡查清单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CurrentRiskPostList currentRiskPostList)
    {
        return toAjax(currentRiskPostListService.updateCurrentRiskPostList(currentRiskPostList));
    }

    /**
     * 删除现状风险岗位用户巡查清单
     */
    @PreAuthorize("@ss.hasPermi('system:riskPostList:remove')")
    @Log(title = "现状风险岗位用户巡查清单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(currentRiskPostListService.deleteCurrentRiskPostListByIds(ids));
    }
}
