package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.censoft.censoftrongtong.domain.RiskPlanTask;
import com.censoft.censoftrongtong.mapper.RiskPlanTaskMapper;
import com.censoft.censoftrongtong.service.IRiskPlanTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 风险计划任务Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanTaskServiceImpl implements IRiskPlanTaskService
{
    @Autowired
    private RiskPlanTaskMapper riskPlanTaskMapper;

    /**
     * 查询风险计划任务
     * 
     * @param id 风险计划任务主键
     * @return 风险计划任务
     */
    @Override
    public RiskPlanTask selectRiskPlanTaskById(Long id)
    {
        return riskPlanTaskMapper.selectRiskPlanTaskById(id);
    }

    /**
     * 查询风险计划任务列表
     * 
     * @param riskPlanTask 风险计划任务
     * @return 风险计划任务
     */
    @Override
    public List<RiskPlanTask> selectRiskPlanTaskList(RiskPlanTask riskPlanTask)
    {
        return riskPlanTaskMapper.selectRiskPlanTaskList(riskPlanTask);
    }

    /**
     * 新增风险计划任务
     * 
     * @param riskPlanTask 风险计划任务
     * @return 结果
     */
    @Override
    public int insertRiskPlanTask(RiskPlanTask riskPlanTask)
    {
        return riskPlanTaskMapper.insertRiskPlanTask(riskPlanTask);
    }

    /**
     * 修改风险计划任务
     * 
     * @param riskPlanTask 风险计划任务
     * @return 结果
     */
    @Override
    public int updateRiskPlanTask(RiskPlanTask riskPlanTask)
    {
        return riskPlanTaskMapper.updateRiskPlanTask(riskPlanTask);
    }

    /**
     * 批量删除风险计划任务
     * 
     * @param ids 需要删除的风险计划任务主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanTaskByIds(Long[] ids)
    {
        return riskPlanTaskMapper.deleteRiskPlanTaskByIds(ids);
    }

    /**
     * 删除风险计划任务信息
     * 
     * @param id 风险计划任务主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanTaskById(Long id)
    {
        return riskPlanTaskMapper.deleteRiskPlanTaskById(id);
    }

    @Override
    public RiskPlanTask getLastRiskPlanTaskByPlanId(Long id) {
        return riskPlanTaskMapper.getLastRiskPlanTaskByPlanId(id);
    }
}
