package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.RiskPlanUserBuilding;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppApproveBuildingDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppBuildingListDto;
import com.github.yulichang.base.MPJBaseService;

import java.util.List;

/**
 * 基Service接口
 *
 * @author ruoyi
 * @date 2023-06-26
 */
public interface IRiskPlanUserBuildingService extends MPJBaseService<RiskPlanUserBuilding> {

    Long countStatusByPlanIdAndStatus(Long planId, String status);

    List<RiskPlanAppBuildingListDto> getRiskPlanAppBuildingListDtoByPlanId(Long planId);

    Integer submitByPlanIdAndBuildingId(Long planId, Long buildingId, Long userId);

    void updateByRiskPlanAppApproveBuildingDto(Long planId,Long userId, List<RiskPlanAppApproveBuildingDto> buildingDtos);

    void deleteByPlanId(Long planId);
}
