package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.censoft.censoftrongtong.domain.RiskNumIndex;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.censoft.censoftrongtong.mapper.RiskNumIndexMapper;
import com.censoft.censoftrongtong.service.IRiskNumIndexService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 风险数量系数Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
@Service
public class RiskNumIndexServiceImpl extends MPJBaseServiceImpl<RiskNumIndexMapper, RiskNumIndex> implements IRiskNumIndexService
{
    @Autowired
    private RiskNumIndexMapper riskNumIndexMapper;

    /**
     * 查询风险数量系数
     * 
     * @param id 风险数量系数主键
     * @return 风险数量系数
     */
    @Override
    public RiskNumIndex selectRiskNumIndexById(Long id)
    {
        return riskNumIndexMapper.selectRiskNumIndexById(id);
    }

    /**
     * 查询风险数量系数列表
     * 
     * @param riskNumIndex 风险数量系数
     * @return 风险数量系数
     */
    @Override
    public List<RiskNumIndex> selectRiskNumIndexList(RiskNumIndex riskNumIndex)
    {
        return riskNumIndexMapper.selectRiskNumIndexList(riskNumIndex);
    }

    /**
     * 新增风险数量系数
     * 
     * @param riskNumIndex 风险数量系数
     * @return 结果
     */
    @Override
    public int insertRiskNumIndex(RiskNumIndex riskNumIndex)
    {
        riskNumIndex.setCreateTime(DateUtils.getNowDate());
        return riskNumIndexMapper.insertRiskNumIndex(riskNumIndex);
    }

    /**
     * 修改风险数量系数
     * 
     * @param riskNumIndex 风险数量系数
     * @return 结果
     */
    @Override
    public int updateRiskNumIndex(RiskNumIndex riskNumIndex)
    {
        riskNumIndex.setUpdateTime(DateUtils.getNowDate());
        return riskNumIndexMapper.updateRiskNumIndex(riskNumIndex);
    }

    /**
     * 批量删除风险数量系数
     * 
     * @param ids 需要删除的风险数量系数主键
     * @return 结果
     */
    @Override
    public int deleteRiskNumIndexByIds(Long[] ids)
    {
        return riskNumIndexMapper.deleteRiskNumIndexByIds(ids);
    }

    /**
     * 删除风险数量系数信息
     * 
     * @param id 风险数量系数主键
     * @return 结果
     */
    @Override
    public int deleteRiskNumIndexById(Long id)
    {
        return riskNumIndexMapper.deleteRiskNumIndexById(id);
    }
}
