package com.ruoyi.system.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.system.mapper.MessageInfoMapper;
import com.ruoyi.system.domain.MessageInfo;
import com.ruoyi.system.service.IMessageInfoService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 消息信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2024-01-09
 */
@Service
public class MessageInfoServiceImpl extends MPJBaseServiceImpl<MessageInfoMapper, MessageInfo> implements IMessageInfoService
{
    @Autowired
    private MessageInfoMapper messageInfoMapper;

    /**
     * 查询消息信息
     * 
     * @param id 消息信息主键
     * @return 消息信息
     */
    @Override
    public MessageInfo selectMessageInfoById(String id)
    {
        return messageInfoMapper.selectMessageInfoById(id);
    }

    /**
     * 查询消息信息列表
     * 
     * @param messageInfo 消息信息
     * @return 消息信息
     */
    @Override
    public List<MessageInfo> selectMessageInfoList(MessageInfo messageInfo)
    {
        return messageInfoMapper.selectMessageInfoList(messageInfo);
    }

    /**
     * 新增消息信息
     * 
     * @param messageInfo 消息信息
     * @return 结果
     */
    @Override
    public int insertMessageInfo(MessageInfo messageInfo)
    {
        messageInfo.setCreateTime(DateUtils.getNowDate());
        return messageInfoMapper.insertMessageInfo(messageInfo);
    }

    /**
     * 修改消息信息
     * 
     * @param messageInfo 消息信息
     * @return 结果
     */
    @Override
    public int updateMessageInfo(MessageInfo messageInfo)
    {
        messageInfo.setUpdateTime(DateUtils.getNowDate());
        return messageInfoMapper.updateMessageInfo(messageInfo);
    }

    /**
     * 批量删除消息信息
     * 
     * @param ids 需要删除的消息信息主键
     * @return 结果
     */
    @Override
    public int deleteMessageInfoByIds(String[] ids)
    {
        return messageInfoMapper.deleteMessageInfoByIds(ids);
    }

    /**
     * 删除消息信息信息
     * 
     * @param id 消息信息主键
     * @return 结果
     */
    @Override
    public int deleteMessageInfoById(String id)
    {
        return messageInfoMapper.deleteMessageInfoById(id);
    }
}
