package com.censoft.censoftrongtong.service;

import java.util.List;

import com.censoft.censoftrongtong.domain.RiskNumIndex;
import com.github.yulichang.base.MPJBaseService;
/**
 * 风险数量系数Service接口
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
public interface IRiskNumIndexService  extends MPJBaseService<RiskNumIndex>
{
    /**
     * 查询风险数量系数
     * 
     * @param id 风险数量系数主键
     * @return 风险数量系数
     */
    public RiskNumIndex selectRiskNumIndexById(Long id);

    /**
     * 查询风险数量系数列表
     * 
     * @param riskNumIndex 风险数量系数
     * @return 风险数量系数集合
     */
    public List<RiskNumIndex> selectRiskNumIndexList(RiskNumIndex riskNumIndex);

    /**
     * 新增风险数量系数
     * 
     * @param riskNumIndex 风险数量系数
     * @return 结果
     */
    public int insertRiskNumIndex(RiskNumIndex riskNumIndex);

    /**
     * 修改风险数量系数
     * 
     * @param riskNumIndex 风险数量系数
     * @return 结果
     */
    public int updateRiskNumIndex(RiskNumIndex riskNumIndex);

    /**
     * 批量删除风险数量系数
     * 
     * @param ids 需要删除的风险数量系数主键集合
     * @return 结果
     */
    public int deleteRiskNumIndexByIds(Long[] ids);

    /**
     * 删除风险数量系数信息
     * 
     * @param id 风险数量系数主键
     * @return 结果
     */
    public int deleteRiskNumIndexById(Long id);
}
