package com.censoft.censoftrongtong.service;

import java.util.List;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrol;
import com.censoft.censoftrongtong.domain.LedgerProject;
import com.github.yulichang.base.MPJBaseService;
/**
 * 巡查执行管理Service接口
 * 
 * @author baode
 * @date 2023-12-05
 */
public interface ICurrentRiskUserPatrolService  extends MPJBaseService<CurrentRiskUserPatrol>
{
    /**
     * 查询巡查执行管理
     * 
     * @param id 巡查执行管理主键
     * @return 巡查执行管理
     */
    public CurrentRiskUserPatrol selectCurrentRiskUserPatrolById(Long id);

    /**
     * 查询巡查执行管理列表
     * 
     * @param currentRiskUserPatrol 巡查执行管理
     * @return 巡查执行管理集合
     */
    public List<CurrentRiskUserPatrol> selectCurrentRiskUserPatrolList(CurrentRiskUserPatrol currentRiskUserPatrol);

    /**
     * 根据用户id查询巡检项目列表
     * @param userId
     * @return
     */
    public List<LedgerProject> getPatrolProjectList(Long userId);
    /**
     * 新增巡查执行管理
     * 
     * @param currentRiskUserPatrol 巡查执行管理
     * @return 结果
     */
    public int insertCurrentRiskUserPatrol(CurrentRiskUserPatrol currentRiskUserPatrol);

    /**
     * 修改巡查执行管理
     * 
     * @param currentRiskUserPatrol 巡查执行管理
     * @return 结果
     */
    public int updateCurrentRiskUserPatrol(CurrentRiskUserPatrol currentRiskUserPatrol);

    /**
     * 批量删除巡查执行管理
     * 
     * @param ids 需要删除的巡查执行管理主键集合
     * @return 结果
     */
    public int deleteCurrentRiskUserPatrolByIds(Long[] ids);

    /**
     * 删除巡查执行管理信息
     * 
     * @param id 巡查执行管理主键
     * @return 结果
     */
    public int deleteCurrentRiskUserPatrolById(Long id);
}
