package com.ruoyi.system.service;

import java.util.List;
import java.util.Map;

import com.ruoyi.system.domain.BacklogInfo;
import com.github.yulichang.base.MPJBaseService;
/**
 * 待办信息Service接口
 * 
 * @author ruoyi
 * @date 2024-01-09
 */
public interface IBacklogInfoService  extends MPJBaseService<BacklogInfo>
{
    /**
     * 查询待办信息
     * 
     * @param id 待办信息主键
     * @return 待办信息
     */
    public BacklogInfo selectBacklogInfoById(String id);

    /**
     * 查询待办信息列表
     * 
     * @param backlogInfo 待办信息
     * @return 待办信息集合
     */
    public List<BacklogInfo> selectBacklogInfoList(BacklogInfo backlogInfo);

    /**
     * 查询待办未读信息数量
     */
    public int selectUnReadCount(String loginName, String app_url, String menu_url);

    /**
     * 查询待办信息各状态数量
     */
    Map<String,Integer> getStatusCount(String loginName, String beginTime, String endTime, String keyword);

    /**
     * 清除未读
     */
    public boolean updateChangeStatus(String loginName);

    /**
     * 新增待办信息
     * 
     * @param backlogInfo 待办信息
     * @return 结果
     */
    public int insertBacklogInfo(BacklogInfo backlogInfo);

    /**
     * 修改待办信息
     * 
     * @param backlogInfo 待办信息
     * @return 结果
     */
    public int updateBacklogInfo(BacklogInfo backlogInfo);

    /**
     * 批量删除待办信息
     * 
     * @param ids 需要删除的待办信息主键集合
     * @return 结果
     */
    public int deleteBacklogInfoByIds(String[] ids);

    /**
     * 删除待办信息信息
     * 
     * @param id 待办信息主键
     * @return 结果
     */
    public int deleteBacklogInfoById(String id);
}
