package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 基础数据-楼宇对象 ledger_building
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class LedgerBuilding extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 项目id */
    private Long projectId;

    /** 楼宇名称 */
    @Excel(name = "楼宇名称",sort = 2)
    private String name;

    /** 资产类型 */
    @Excel(name = "资产类型",sort = 3)
    private String type;

    /** 组织机构id */
    private Long deptId;

    /** 楼层 */
    @Excel(name = "楼层数（层）",sort = 5)
    private String floor;

    /** 地上楼层 */
    private Integer groundFloor;

    /** 地下楼层 */
    private Integer undergroundFloor;

    /** 用途 */
    @Excel(name = "用途",sort = 6)
    private String useto;

    /** 所在城市 */
    @Excel(name = "所在城市",sort = 7)
    private String city;

    /** 资产面积 */
    private BigDecimal area;

    /** 详细地址 */
    @Excel(name = "详细地址",sort = 8)
    private String address;

    /** 中台楼宇id */
    private String infoAssetsId;

    /** 状态（0正常 1停用） */
    @Excel(name = "状态", readConverterExp = "0=正常,1=停用")
    private String status;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;
    /**
     * 项目名称
     */
    @TableField(exist = false)
    @Excel(name = "项目名称",sort = 1)
    private String projectName;

    /**
     * 组织名称
     */
    @TableField(exist = false)
    @Excel(name = "所属区域",sort = 4)
    private String deptName;

    /**
     * 数量
     */
    @TableField(exist = false)
    private String num;

    /**
     * 楼栋风险指数
     */
    private BigDecimal riskIndex;
    private String riskLevel;
    private String riskColor;



}
