package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;

/**
 * 评估选项管理对象 evaluation_factor_items
 * 
 * @author xjchen
 * @date 2023-08-08
 */
@Data
public class EvaluationFactorItems extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @TableId(type = IdType.AUTO)
    private Long id;

    /** 影响因子id */
    @Excel(name = "影响因子id")
    private Long factorId;

    /** 所属指标项 */
    @Excel(name = "所属指标项")
    private String indicatorBelong;

    /** 指标项值 */
    @Excel(name = "指标项值")
    private String indicatorItem;

    /** 指标分值 */
    @Excel(name = "指标分值")
    private Integer indicatorScore;

    /** 是否重大影响(0:一般,1:重大) */
    @Excel(name = "是否重大影响(0:一般,1:重大)")
    private String isImportant;

    /** 排序 */
    @Excel(name = "排序")
    private Integer sortNum;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    @TableField(exist = false)
    private String InfluenceSubFactor;



}
