package com.censoft.censoftrongtong.domain;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 现状风险巡查用户请假对象 current_risk_user_holiday
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
@Data
public class CurrentRiskUserHoliday extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** 主键 id */
    private Long id;

    /** 申请人用户 id */
    @Excel(name = "申请人用户 id")
    private Long applyUserId;

    /** 审批人用户 id */
    @Excel(name = "审批人用户 id")
    private Long approveUserId;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /** 审批时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "审批时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date approveTime;

    /** 假期时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "假期时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date holidayTime;

    /** 请假原因 */
    @Excel(name = "请假原因")
    private String reason;

    /** 审批描述 */
    @Excel(name = "审批描述")
    private String approveMsg;

    /** 状态 0 待审批 1 已通过 2 已拒绝 */
    @Excel(name = "状态 0 待审批 1 已通过 2 已拒绝")
    private String status;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNum;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    @TableField(exist = false)
    private String type;

    @TableField(exist = false)
    private String applyUserName;

    @TableField(exist = false)
    private String approveUserName;
}
